/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.internal.XSPrincipal;

final class XSPrincipalI
extends XSPrincipal {
    long kpxsprindbid = 0L;
    String kpxsprinname = null;
    byte[] kpxsprinnameBytes = null;
    byte[] kpxsprinuuid = null;
    XSPrincipal.Flag kpxsprinflg = XSPrincipal.Flag.KPXS_PRIN_EXT;

    XSPrincipalI() {
    }

    @Override
    public void setDatabaseId(long kpxsprindbid) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.kpxsprindbid = kpxsprindbid;
    }

    @Override
    public void setName(String kpxsprinname) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.kpxsprinname = kpxsprinname;
    }

    @Override
    public void setUUID(byte[] kpxsprinuuid) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.kpxsprinuuid = (byte[])(kpxsprinuuid == null ? null : Arrays.copyOf(kpxsprinuuid, kpxsprinuuid.length));
    }

    @Override
    public void setFlag(XSPrincipal.Flag kpxsprinflg) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.kpxsprinflg = kpxsprinflg;
    }

    @Override
    public long getDatabaseId() {
        InternalFactory.xsSecurityCheck();
        return this.kpxsprindbid;
    }

    @Override
    public String getName() {
        InternalFactory.xsSecurityCheck();
        return this.kpxsprinname;
    }

    @Override
    public byte[] getUUID() {
        InternalFactory.xsSecurityCheck();
        return this.kpxsprinuuid;
    }

    @Override
    public XSPrincipal.Flag getFlag() {
        InternalFactory.xsSecurityCheck();
        return this.kpxsprinflg;
    }

    void doCharConversion(DBConversion conv) throws SQLException {
        this.kpxsprinnameBytes = (byte[])(this.kpxsprinname != null ? conv.StringToCharBytes(this.kpxsprinname) : null);
    }

    void marshal(T4CMAREngine mar) throws IOException {
        mar.marshalSB8(this.kpxsprindbid);
        if (this.kpxsprinnameBytes != null) {
            mar.marshalUB4(this.kpxsprinnameBytes.length);
            mar.marshalCLR(this.kpxsprinnameBytes, this.kpxsprinnameBytes.length);
        } else {
            mar.marshalUB4(0L);
        }
        if (this.kpxsprinuuid != null) {
            mar.marshalUB4(this.kpxsprinuuid.length);
            mar.marshalCLR(this.kpxsprinuuid, this.kpxsprinuuid.length);
        } else {
            mar.marshalUB4(0L);
        }
        mar.marshalUB4(this.kpxsprinflg.getMode());
    }

    static XSPrincipalI unmarshal(T4CMAREngine mar) throws SQLException, IOException {
        long _kpxsprinflg;
        int[] intArr = new int[1];
        long kpxsprindbid = mar.unmarshalSB8();
        String kpxsprinname = null;
        int kpxsprinnameBytesLength = (int)mar.unmarshalUB4();
        if (kpxsprinnameBytesLength > 0) {
            byte[] kpxsprinnameBytes = new byte[kpxsprinnameBytesLength];
            mar.unmarshalCLR(kpxsprinnameBytes, 0, intArr);
            kpxsprinname = mar.conv.CharBytesToString(kpxsprinnameBytes, intArr[0]);
        }
        byte[] kpxsprinuuid = null;
        int kpxsprinuuidLength = (int)mar.unmarshalUB4();
        if (kpxsprinuuidLength > 0) {
            mar.unmarshalUB1();
            kpxsprinuuid = mar.unmarshalNBytes(kpxsprinuuidLength);
        }
        XSPrincipal.Flag kpxsprinflg = (_kpxsprinflg = mar.unmarshalUB4()) == XSPrincipal.Flag.KPXS_PRIN_EXT.getMode() ? XSPrincipal.Flag.KPXS_PRIN_EXT : XSPrincipal.Flag.KPXS_PRIN_USEDBID;
        XSPrincipalI principal = new XSPrincipalI();
        principal.setDatabaseId(kpxsprindbid);
        principal.setName(kpxsprinname);
        principal.setUUID(kpxsprinuuid);
        principal.setFlag(kpxsprinflg);
        return principal;
    }
}

