/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PatchOperation
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PatchOperation> {
    @Nonnull
    private final String op;
    @Nonnull
    private final String path;
    @Nullable
    private final JsonData value;
    public static final JsonpDeserializer<PatchOperation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatchOperation::setupPatchOperationDeserializer);

    private PatchOperation(Builder builder) {
        this.op = ApiTypeHelper.requireNonNull(builder.op, this, "op");
        this.path = ApiTypeHelper.requireNonNull(builder.path, this, "path");
        this.value = builder.value;
    }

    public static PatchOperation of(Function<Builder, ObjectBuilder<PatchOperation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String op() {
        return this.op;
    }

    @Nonnull
    public final String path() {
        return this.path;
    }

    @Nullable
    public final JsonData value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("op");
        generator.write(this.op);
        generator.writeKey("path");
        generator.write(this.path);
        if (this.value != null) {
            generator.writeKey("value");
            this.value.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPatchOperationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::op, JsonpDeserializer.stringDeserializer(), "op");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::value, JsonData._DESERIALIZER, "value");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.op.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchOperation other = (PatchOperation)o;
        return this.op.equals(other.op) && this.path.equals(other.path) && Objects.equals(this.value, other.value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, PatchOperation> {
        private String op;
        private String path;
        @Nullable
        private JsonData value;

        public Builder() {
        }

        private Builder(PatchOperation o) {
            this.op = o.op;
            this.path = o.path;
            this.value = o.value;
        }

        private Builder(Builder o) {
            this.op = o.op;
            this.path = o.path;
            this.value = o.value;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder op(String value) {
            this.op = value;
            return this;
        }

        @Nonnull
        public final Builder path(String value) {
            this.path = value;
            return this;
        }

        @Nonnull
        public final Builder value(@Nullable JsonData value) {
            this.value = value;
            return this;
        }

        @Override
        @Nonnull
        public PatchOperation build() {
            this._checkSingleUse();
            return new PatchOperation(this);
        }
    }
}

