/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors.telemetry;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.util.concurrent.SizeBlockingQueue;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.TelemetryCollector;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.RTFMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.telemetry.metrics.Histogram;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.tags.Tags;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.threadpool.ThreadPoolStats;

public class RTFThreadPoolMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements TelemetryCollector {
    private static final Logger LOG = LogManager.getLogger(RTFThreadPoolMetricsCollector.class);
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(RTFThreadPoolMetricsCollector.class)).samplingInterval;
    private final Map<String, ThreadPoolStatsRecord> statsRecordMap = new HashMap<String, ThreadPoolStatsRecord>();
    private Histogram threadPoolQueueSizeMetrics;
    private Histogram threadPoolRejectedReqsMetrics;
    private Histogram threadPoolTotalThreadsMetrics;
    private Histogram threadPoolActiveThreadsMetrics;
    private Histogram ThreadPoolQueueCapacityMetrics;
    private MetricsRegistry metricsRegistry;
    private boolean metricsInitialised = false;
    private PerformanceAnalyzerController performanceAnalyzerController;
    private ConfigOverridesWrapper configOverridesWrapper;

    public RTFThreadPoolMetricsCollector(PerformanceAnalyzerController performanceAnalyzerController, ConfigOverridesWrapper configOverridesWrapper) {
        super(SAMPLING_TIME_INTERVAL, "RTFThreadPoolMetricsCollector", (MeasurementSet)StatMetrics.RTF_THREADPOOL_METRICS_COLLECTOR_EXECUTION_TIME, StatExceptionCode.RTF_THREADPOOL_METRICS_COLLECTOR_ERROR);
        this.performanceAnalyzerController = performanceAnalyzerController;
        this.configOverridesWrapper = configOverridesWrapper;
    }

    public void collectMetrics(long startTime) {
        if (this.performanceAnalyzerController.isCollectorDisabled(this.configOverridesWrapper, this.getCollectorName())) {
            LOG.info("RTFDisksCollector is disabled. Skipping collection.");
            return;
        }
        if (OpenSearchResources.INSTANCE.getThreadPool() == null) {
            return;
        }
        this.metricsRegistry = OpenSearchResources.INSTANCE.getMetricsRegistry();
        if (this.metricsRegistry == null) {
            LOG.error("could not get the instance of MetricsRegistry class");
            return;
        }
        LOG.debug("Executing collect metrics for RTFThreadPoolMetricsCollector");
        this.initialiseMetricsIfNeeded();
        for (ThreadPoolStats.Stats stats : OpenSearchResources.INSTANCE.getThreadPool().stats()) {
            ThreadPoolStatsRecord lastRecord;
            long rejectionDelta = 0L;
            String threadPoolName = stats.getName();
            if (this.statsRecordMap.containsKey(threadPoolName) && startTime - (lastRecord = this.statsRecordMap.get(threadPoolName)).getTimestamp() <= (long)SAMPLING_TIME_INTERVAL * 3L && (rejectionDelta = stats.getRejected() - lastRecord.getRejected()) < 0L) {
                rejectionDelta = 0L;
            }
            this.statsRecordMap.put(threadPoolName, new ThreadPoolStatsRecord(startTime, stats.getRejected()));
            long finalRejectionDelta = rejectionDelta;
            int capacity = AccessController.doPrivileged(() -> {
                try {
                    ThreadPool threadPool = (ThreadPool)FieldUtils.readField((Object)OpenSearchResources.INSTANCE.getIndicesService(), (String)"threadPool", (boolean)true);
                    ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)threadPool.executor(threadPoolName);
                    BlockingQueue<Runnable> queue = threadPoolExecutor.getQueue();
                    if (queue instanceof SizeBlockingQueue) {
                        return ((SizeBlockingQueue)queue).capacity();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Fail to read queue capacity via reflection");
                    StatsCollector.instance().logException(StatExceptionCode.THREADPOOL_METRICS_COLLECTOR_ERROR);
                }
                return -1;
            });
            this.recordMetrics(stats, finalRejectionDelta, capacity);
        }
    }

    private void recordMetrics(ThreadPoolStats.Stats stats, long finalRejectionDelta, int capacity) {
        Tags threadPoolTypeTag = Tags.create().addTag(RTFMetrics.ThreadPoolDimension.THREAD_POOL_TYPE.toString(), stats.getName());
        this.threadPoolQueueSizeMetrics.record((double)stats.getQueue(), threadPoolTypeTag);
        this.threadPoolRejectedReqsMetrics.record((double)finalRejectionDelta, threadPoolTypeTag);
        this.threadPoolActiveThreadsMetrics.record((double)stats.getActive(), threadPoolTypeTag);
        this.threadPoolTotalThreadsMetrics.record((double)stats.getThreads(), threadPoolTypeTag);
        if (capacity >= 0) {
            this.ThreadPoolQueueCapacityMetrics.record((double)capacity, threadPoolTypeTag);
        }
    }

    private void initialiseMetricsIfNeeded() {
        if (!this.metricsInitialised) {
            this.threadPoolQueueSizeMetrics = this.metricsRegistry.createHistogram("threadpool_queue_size", "ThreadPool Queue Size Metrics", RTFMetrics.MetricUnits.COUNT.toString());
            this.threadPoolRejectedReqsMetrics = this.metricsRegistry.createHistogram("threadpool_rejected_reqs", "ThreadPool Rejected Reqs Metrics", RTFMetrics.MetricUnits.COUNT.toString());
            this.threadPoolTotalThreadsMetrics = this.metricsRegistry.createHistogram("threadpool_total_threads", "ThreadPool Total Threads Metrics", RTFMetrics.MetricUnits.COUNT.toString());
            this.threadPoolActiveThreadsMetrics = this.metricsRegistry.createHistogram("threadpool_active_threads", "ThreadPool Active Threads Metrics", RTFMetrics.MetricUnits.COUNT.toString());
            this.ThreadPoolQueueCapacityMetrics = this.metricsRegistry.createHistogram("threadpool_queue_capacity", "ThreadPool Queue Capacity Metrics", RTFMetrics.MetricUnits.COUNT.toString());
            this.metricsInitialised = true;
        }
    }

    private static class ThreadPoolStatsRecord {
        private final long timestamp;
        private final long rejected;

        ThreadPoolStatsRecord(long timestamp, long rejected) {
            this.timestamp = timestamp;
            this.rejected = rejected;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getRejected() {
            return this.rejected;
        }
    }
}

