/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.theme;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.klimt.sprite.ResourcesUtils;
import net.sourceforge.plantuml.nio.InputFile;
import net.sourceforge.plantuml.nio.PathSystem;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.preproc2.PreprocessorUtils;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.theme.Theme;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.utils.Log;

public class ThemeUtils {
    private static final String THEME_FILE_PREFIX = "puml-theme-";
    private static final String THEME_FILE_SUFFIX = ".puml";
    private static final String THEME_PATH = "themes";

    public static Theme loadTheme(PathSystem pathSystem, String name, String from, StringLocated location) throws IOException, EaterException {
        if (from == null) {
            return ThemeUtils.loadBundledOrLocalTheme(pathSystem, name);
        }
        if (from.startsWith("<") && from.endsWith(">")) {
            return ThemeUtils.loadStdlibTheme(name, from);
        }
        if (from.startsWith("http://") || from.startsWith("https://")) {
            return ThemeUtils.loadHttpTheme(name, from, location);
        }
        return ThemeUtils.loadFileTheme(pathSystem, name, from);
    }

    private static Theme loadBundledOrLocalTheme(PathSystem pathSystem, String name) throws IOException {
        Reader br;
        Log.info(() -> "Loading theme " + name);
        String res = "/themes/" + ThemeUtils.getFilename(name);
        InputStream is = Stdlib.class.getResourceAsStream(res);
        if (is != null) {
            String description = "<" + res + ">";
            return new Theme(ReadLineReader.create(new InputStreamReader(is), description));
        }
        InputFile localFile = pathSystem.getInputFile(ThemeUtils.getFilename(name));
        if (localFile != null && (br = localFile.getReader(StandardCharsets.UTF_8)) != null) {
            return new Theme(ReadLineReader.create(br, "theme " + name));
        }
        return null;
    }

    private static Theme loadStdlibTheme(String name, String from) {
        String realFrom = from.substring(1, from.length() - 1);
        String res = realFrom + "/" + ThemeUtils.getFilename(name);
        byte[] content = Stdlib.getPumlResource(res);
        if (content == null) {
            return null;
        }
        String description = name + " from " + from;
        return new Theme(ReadLineReader.create(content, description));
    }

    private static Theme loadHttpTheme(String name, String from, StringLocated location) throws UnsupportedEncodingException, EaterException {
        SURL url = SURL.create(ThemeUtils.getFullPath(from, name));
        if (url == null) {
            throw new EaterException("Cannot open URL", location);
        }
        return new Theme(PreprocessorUtils.getReaderInclude(url, location, StandardCharsets.UTF_8));
    }

    private static String getFullPath(String from, String filename) {
        StringBuilder sb = new StringBuilder(from);
        if (!from.endsWith("/")) {
            sb.append("/");
        }
        return sb + ThemeUtils.getFilename(filename);
    }

    private static Theme loadFileTheme(PathSystem pathSystem, String name, String from) throws IOException {
        InputFile file = pathSystem.getInputFile(from + ThemeUtils.getFilename(name));
        InputStream is = file.newInputStream();
        if (is == null) {
            return null;
        }
        String description = name + " from " + from;
        return new Theme(ReadLineReader.create(new InputStreamReader(is), description));
    }

    public static List<String> getAllThemeNames() throws IOException {
        Collection filenames = Objects.requireNonNull(ResourcesUtils.getJarFile(THEME_PATH, false));
        ArrayList<String> result = new ArrayList<String>();
        for (String f : filenames) {
            if (!f.startsWith(THEME_FILE_PREFIX) || !f.endsWith(THEME_FILE_SUFFIX)) continue;
            result.add(f.substring(THEME_FILE_PREFIX.length(), f.length() - THEME_FILE_SUFFIX.length()));
        }
        Collections.sort(result);
        return result;
    }

    public static String getFilename(String filename) {
        return THEME_FILE_PREFIX + filename + THEME_FILE_SUFFIX;
    }
}

