/*
 * Decompiled with CFR 0.152.
 */
package hughai.packcoordinators;

import com.springrts.ai.oo.clb.Unit;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.basictypes.Float3;
import hughai.basictypes.TerrainPos;
import hughai.packcoordinators.PackCoordinator;

public class SpreadSearchPackCoordinator
extends PackCoordinator {
    Float3 targetpos;
    TerrainPos lasttargetpos = null;

    public SpreadSearchPackCoordinator(PlayerObjects playerObjects) {
        super(playerObjects);
        this.csai.registerGameListener(new GameListenerHandler());
    }

    @Override
    public void SetTarget(TerrainPos terrainPos) {
        this.targetpos = terrainPos;
    }

    @Override
    public void Activate() {
        if (!this.activated) {
            this.logfile.WriteLine("SpreadSearchPackCoordinator initiating spreadsearch");
            this.activated = true;
            this.restartedfrompause = true;
            this.Recoordinate();
        }
    }

    @Override
    public void Disactivate() {
        if (this.activated) {
            this.activated = false;
            this.logfile.WriteLine("SpreadSearchPackCoordinator shutting down");
        }
    }

    @Override
    void Recoordinate() {
        if (!this.activated) {
            return;
        }
        for (Unit unit : this.unitsControlled) {
            this.ExploreWith(unit);
        }
    }

    void ExploreWith(Unit unit) {
        TerrainPos terrainPos = this.GetRandomDestination();
        this.giveOrderWrapper.MoveTo(unit, terrainPos);
    }

    TerrainPos GetRandomDestination() {
        TerrainPos terrainPos = new TerrainPos();
        float f = this.random.nextFloat() * (float)this.aicallback.getMap().getWidth();
        this.maps.getMovementMaps().getClass();
        terrainPos.x = f * 8.0f;
        float f2 = this.random.nextFloat() * (float)this.aicallback.getMap().getHeight();
        this.maps.getMovementMaps().getClass();
        terrainPos.z = f2 * 8.0f;
        terrainPos.y = this.aicallback.getMap().getElevationAt(terrainPos.x, terrainPos.y);
        return terrainPos;
    }

    class GameListenerHandler
    extends GameAdapter {
        GameListenerHandler() {
        }

        @Override
        public void UnitIdle(Unit unit) {
            if (SpreadSearchPackCoordinator.this.activated && SpreadSearchPackCoordinator.this.unitsControlled.contains(unit)) {
                SpreadSearchPackCoordinator.this.ExploreWith(unit);
            }
        }

        @Override
        public void Tick(int n) {
        }
    }
}

