/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.DocumentBlockType;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.latex.LaTeXFloat;
import java.io.IOException;

public class L2HFloat
extends LaTeXFloat {
    public L2HFloat(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new L2HFloat(this.getName());
    }

    @Override
    public void startFloat(String string, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.startFloat(string, teXParser);
    }

    @Override
    public void startFloat(String string, TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        l2HConverter.endParagraph();
        if (this.getName().equals("figure") && l2HConverter.isHtml5()) {
            l2HConverter.writeliteral("<figure>");
        } else {
            l2HConverter.writeliteralln("<div class=\"" + this.getName() + "\">");
        }
        l2HConverter.setCurrentBlockType(DocumentBlockType.BLOCK);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (this.getName().equals("figure")) {
            l2HConverter.writeEndHtml5OrDiv("figure", true);
        } else {
            l2HConverter.writeliteralln("</div>");
        }
        l2HConverter.setCurrentBlockType(DocumentBlockType.BODY);
    }
}

