/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Decoder;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.PongMessage;
import jakarta.websocket.Session;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.naming.NamingException;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.DecoderEntry;
import org.apache.tomcat.websocket.MessageHandlerResult;
import org.apache.tomcat.websocket.MessageHandlerResultType;
import org.apache.tomcat.websocket.WsExtension;
import org.apache.tomcat.websocket.WsExtensionParameter;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerPartialBinary;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeBinary;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeText;

public class Util {
    private static final StringManager sm = StringManager.getManager(Util.class);
    private static final Queue<SecureRandom> randoms = new ConcurrentLinkedQueue<SecureRandom>();

    private Util() {
    }

    static boolean isControl(byte by) {
        return (by & 8) != 0;
    }

    static boolean isText(byte by) {
        return by == 1;
    }

    static boolean isContinuation(byte by) {
        return by == 0;
    }

    static CloseReason.CloseCode getCloseCode(int n) {
        if (n > 2999 && n < 5000) {
            return CloseReason.CloseCodes.getCloseCode((int)n);
        }
        switch (n) {
            case 1000: {
                return CloseReason.CloseCodes.NORMAL_CLOSURE;
            }
            case 1001: {
                return CloseReason.CloseCodes.GOING_AWAY;
            }
            case 1002: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1003: {
                return CloseReason.CloseCodes.CANNOT_ACCEPT;
            }
            case 1004: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1005: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1006: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1007: {
                return CloseReason.CloseCodes.NOT_CONSISTENT;
            }
            case 1008: {
                return CloseReason.CloseCodes.VIOLATED_POLICY;
            }
            case 1009: {
                return CloseReason.CloseCodes.TOO_BIG;
            }
            case 1010: {
                return CloseReason.CloseCodes.NO_EXTENSION;
            }
            case 1011: {
                return CloseReason.CloseCodes.UNEXPECTED_CONDITION;
            }
            case 1012: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1013: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1015: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
        }
        return CloseReason.CloseCodes.PROTOCOL_ERROR;
    }

    static byte[] generateMask() {
        SecureRandom secureRandom = randoms.poll();
        if (secureRandom == null) {
            try {
                secureRandom = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                secureRandom = new SecureRandom();
            }
        }
        byte[] byArray = new byte[4];
        secureRandom.nextBytes(byArray);
        randoms.add(secureRandom);
        return byArray;
    }

    static Class<?> getMessageType(MessageHandler messageHandler) {
        return Util.getGenericType(MessageHandler.class, messageHandler.getClass()).getClazz();
    }

    private static Class<?> getDecoderType(Class<? extends Decoder> clazz) {
        return Util.getGenericType(Decoder.class, clazz).getClazz();
    }

    static Class<?> getEncoderType(Class<? extends Encoder> clazz) {
        return Util.getGenericType(Encoder.class, clazz).getClazz();
    }

    private static <T> TypeResult getGenericType(Class<T> clazz, Class<? extends T> clazz2) {
        Class<?> clazz3;
        Type[] typeArray;
        for (Type type : typeArray = clazz2.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType) || !((clazz3 = (ParameterizedType)type).getRawType() instanceof Class) || !clazz.isAssignableFrom((Class)clazz3.getRawType())) continue;
            return Util.getTypeParameter(clazz2, clazz3.getActualTypeArguments()[0]);
        }
        Class<T> clazz4 = clazz2.getSuperclass();
        if (clazz4 == null) {
            throw new IllegalStateException();
        }
        Object object = Util.getGenericType(clazz, clazz4);
        int n = ((TypeResult)object).getDimension();
        if (((TypeResult)object).getIndex() == -1 && n == 0) {
            return object;
        }
        if (((TypeResult)object).getIndex() > -1) {
            ParameterizedType parameterizedType = (ParameterizedType)clazz2.getGenericSuperclass();
            clazz3 = Util.getTypeParameter(clazz2, parameterizedType.getActualTypeArguments()[((TypeResult)object).getIndex()]);
            ((TypeResult)((Object)clazz3)).incrementDimension(((TypeResult)object).getDimension());
            if (((TypeResult)((Object)clazz3)).getClazz() != null && ((TypeResult)((Object)clazz3)).getDimension() > 0) {
                object = clazz3;
            } else {
                return clazz3;
            }
        }
        if (((TypeResult)object).getDimension() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[".repeat(Math.max(0, n)));
            stringBuilder.append('L');
            stringBuilder.append(((TypeResult)object).getClazz().getCanonicalName());
            stringBuilder.append(';');
            try {
                clazz3 = Class.forName(stringBuilder.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException);
            }
            return new TypeResult(clazz3, -1, 0);
        }
        throw new IllegalStateException();
    }

    private static TypeResult getTypeParameter(Class<?> clazz, Type type) {
        if (type instanceof Class) {
            return new TypeResult((Class)type, -1, 0);
        }
        if (type instanceof ParameterizedType) {
            return new TypeResult((Class)((ParameterizedType)type).getRawType(), -1, 0);
        }
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            TypeResult typeResult = Util.getTypeParameter(clazz, type2);
            typeResult.incrementDimension(1);
            return typeResult;
        }
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        for (int i = 0; i < typeVariableArray.length; ++i) {
            if (!typeVariableArray[i].equals(type)) continue;
            return new TypeResult(null, i, 0);
        }
        throw new IllegalStateException();
    }

    public static boolean isPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return clazz.equals(Boolean.class) || clazz.equals(Byte.class) || clazz.equals(Character.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Short.class);
    }

    public static Object coerceToType(Class<?> clazz, String string) {
        if (clazz.equals(String.class)) {
            return string;
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return Boolean.valueOf(string);
        }
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return Byte.valueOf(string);
        }
        if (clazz.equals(Character.TYPE) || clazz.equals(Character.class)) {
            return Character.valueOf(string.charAt(0));
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return Double.valueOf(string);
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return Float.valueOf(string);
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return Integer.valueOf(string);
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return Long.valueOf(string);
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return Short.valueOf(string);
        }
        throw new IllegalArgumentException(sm.getString("util.invalidType", new Object[]{string, clazz.getName()}));
    }

    public static List<DecoderEntry> getDecoders(List<Class<? extends Decoder>> list, InstanceManager instanceManager) throws DeploymentException {
        ArrayList<DecoderEntry> arrayList = new ArrayList<DecoderEntry>();
        if (list != null) {
            for (Class<? extends Decoder> clazz : list) {
                try {
                    Decoder decoder;
                    if (instanceManager == null) {
                        decoder = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    } else {
                        decoder = (Decoder)instanceManager.newInstance(clazz);
                        instanceManager.destroyInstance((Object)decoder);
                    }
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException | NamingException exception) {
                    throw new DeploymentException(sm.getString("pojoMethodMapping.invalidDecoder", new Object[]{clazz.getName()}), (Throwable)exception);
                }
                DecoderEntry decoderEntry = new DecoderEntry(Util.getDecoderType(clazz), clazz);
                arrayList.add(decoderEntry);
            }
        }
        return arrayList;
    }

    static Set<MessageHandlerResult> getMessageHandlers(Class<?> clazz, MessageHandler messageHandler, EndpointConfig endpointConfig, Session session) {
        HashSet<MessageHandlerResult> hashSet = new HashSet<MessageHandlerResult>(2);
        if (String.class.isAssignableFrom(clazz)) {
            MessageHandlerResult messageHandlerResult = new MessageHandlerResult(messageHandler, MessageHandlerResultType.TEXT);
            hashSet.add(messageHandlerResult);
        } else if (ByteBuffer.class.isAssignableFrom(clazz)) {
            MessageHandlerResult messageHandlerResult = new MessageHandlerResult(messageHandler, MessageHandlerResultType.BINARY);
            hashSet.add(messageHandlerResult);
        } else if (PongMessage.class.isAssignableFrom(clazz)) {
            MessageHandlerResult messageHandlerResult = new MessageHandlerResult(messageHandler, MessageHandlerResultType.PONG);
            hashSet.add(messageHandlerResult);
        } else if (byte[].class.isAssignableFrom(clazz)) {
            boolean bl = MessageHandler.Whole.class.isAssignableFrom(messageHandler.getClass());
            MessageHandlerResult messageHandlerResult = new MessageHandlerResult((MessageHandler)(bl ? new PojoMessageHandlerWholeBinary(messageHandler, Util.getOnMessageMethod(messageHandler), session, endpointConfig, Util.matchDecoders(clazz, endpointConfig, true, ((WsSession)session).getInstanceManager()), new Object[1], 0, true, -1, false, -1L) : new PojoMessageHandlerPartialBinary(messageHandler, Util.getOnMessagePartialMethod(messageHandler), session, new Object[2], 0, true, 1, -1, -1L)), MessageHandlerResultType.BINARY);
            hashSet.add(messageHandlerResult);
        } else if (InputStream.class.isAssignableFrom(clazz)) {
            MessageHandlerResult messageHandlerResult = new MessageHandlerResult((MessageHandler)new PojoMessageHandlerWholeBinary(messageHandler, Util.getOnMessageMethod(messageHandler), session, endpointConfig, Util.matchDecoders(clazz, endpointConfig, true, ((WsSession)session).getInstanceManager()), new Object[1], 0, true, -1, true, -1L), MessageHandlerResultType.BINARY);
            hashSet.add(messageHandlerResult);
        } else if (Reader.class.isAssignableFrom(clazz)) {
            MessageHandlerResult messageHandlerResult = new MessageHandlerResult((MessageHandler)new PojoMessageHandlerWholeText(messageHandler, Util.getOnMessageMethod(messageHandler), session, endpointConfig, Util.matchDecoders(clazz, endpointConfig, false, ((WsSession)session).getInstanceManager()), new Object[1], 0, true, -1, -1L), MessageHandlerResultType.TEXT);
            hashSet.add(messageHandlerResult);
        } else {
            MessageHandlerResult messageHandlerResult;
            DecoderMatch decoderMatch = Util.matchDecoders(clazz, endpointConfig, ((WsSession)session).getInstanceManager());
            Method method = Util.getOnMessageMethod(messageHandler);
            if (!decoderMatch.getBinaryDecoders().isEmpty()) {
                messageHandlerResult = new MessageHandlerResult((MessageHandler)new PojoMessageHandlerWholeBinary(messageHandler, method, session, endpointConfig, decoderMatch.getBinaryDecoders(), new Object[1], 0, false, -1, false, -1L), MessageHandlerResultType.BINARY);
                hashSet.add(messageHandlerResult);
            }
            if (!decoderMatch.getTextDecoders().isEmpty()) {
                messageHandlerResult = new MessageHandlerResult((MessageHandler)new PojoMessageHandlerWholeText(messageHandler, method, session, endpointConfig, decoderMatch.getTextDecoders(), new Object[1], 0, false, -1, -1L), MessageHandlerResultType.TEXT);
                hashSet.add(messageHandlerResult);
            }
        }
        if (hashSet.isEmpty()) {
            throw new IllegalArgumentException(sm.getString("wsSession.unknownHandler", new Object[]{messageHandler, clazz}));
        }
        return hashSet;
    }

    private static List<Class<? extends Decoder>> matchDecoders(Class<?> clazz, EndpointConfig endpointConfig, boolean bl, InstanceManager instanceManager) {
        DecoderMatch decoderMatch = Util.matchDecoders(clazz, endpointConfig, instanceManager);
        if (bl) {
            if (!decoderMatch.getBinaryDecoders().isEmpty()) {
                return decoderMatch.getBinaryDecoders();
            }
        } else if (!decoderMatch.getTextDecoders().isEmpty()) {
            return decoderMatch.getTextDecoders();
        }
        return null;
    }

    private static DecoderMatch matchDecoders(Class<?> clazz, EndpointConfig endpointConfig, InstanceManager instanceManager) {
        DecoderMatch decoderMatch;
        try {
            List list = endpointConfig.getDecoders();
            List<DecoderEntry> list2 = Util.getDecoders(list, instanceManager);
            decoderMatch = new DecoderMatch(clazz, list2);
        }
        catch (DeploymentException deploymentException) {
            throw new IllegalArgumentException(deploymentException);
        }
        return decoderMatch;
    }

    public static void parseExtensionHeader(List<Extension> list, String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            String[] stringArray2 = string2.split(";");
            WsExtension wsExtension = new WsExtension(stringArray2[0].trim());
            for (int i = 1; i < stringArray2.length; ++i) {
                String string3;
                String string4;
                int n = stringArray2[i].indexOf(61);
                if (n == -1) {
                    string4 = stringArray2[i].trim();
                    string3 = null;
                } else {
                    string4 = stringArray2[i].substring(0, n).trim();
                    string3 = stringArray2[i].substring(n + 1).trim();
                    int n2 = string3.length();
                    if (n2 > 1 && string3.charAt(0) == '\"' && string3.charAt(n2 - 1) == '\"') {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                }
                if (Util.containsDelims(string4) || Util.containsDelims(string3)) {
                    throw new IllegalArgumentException(sm.getString("util.notToken", new Object[]{string4, string3}));
                }
                if (string3 != null && (string3.indexOf(44) > -1 || string3.indexOf(59) > -1 || string3.indexOf(34) > -1 || string3.indexOf(61) > -1)) {
                    throw new IllegalArgumentException(sm.getString("util.invalidValue", new Object[]{string3}));
                }
                wsExtension.addParameter(new WsExtensionParameter(string4, string3));
            }
            list.add(wsExtension);
        }
    }

    private static boolean containsDelims(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        for (char c : string.toCharArray()) {
            switch (c) {
                case '\"': 
                case ',': 
                case ';': 
                case '=': {
                    return true;
                }
            }
        }
        return false;
    }

    private static Method getOnMessageMethod(MessageHandler messageHandler) {
        try {
            return messageHandler.getClass().getMethod("onMessage", Object.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new IllegalArgumentException(sm.getString("util.invalidMessageHandler"), exception);
        }
    }

    private static Method getOnMessagePartialMethod(MessageHandler messageHandler) {
        try {
            return messageHandler.getClass().getMethod("onMessage", Object.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new IllegalArgumentException(sm.getString("util.invalidMessageHandler"), exception);
        }
    }

    private static class TypeResult {
        private final Class<?> clazz;
        private final int index;
        private int dimension;

        TypeResult(Class<?> clazz, int n, int n2) {
            this.clazz = clazz;
            this.index = n;
            this.dimension = n2;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public int getIndex() {
            return this.index;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void incrementDimension(int n) {
            this.dimension += n;
        }
    }

    public static class DecoderMatch {
        private final List<Class<? extends Decoder>> textDecoders = new ArrayList<Class<? extends Decoder>>();
        private final List<Class<? extends Decoder>> binaryDecoders = new ArrayList<Class<? extends Decoder>>();
        private final Class<?> target;

        public DecoderMatch(Class<?> clazz, List<DecoderEntry> list) {
            this.target = clazz;
            for (DecoderEntry decoderEntry : list) {
                if (!decoderEntry.getClazz().isAssignableFrom(clazz)) continue;
                if (Decoder.Binary.class.isAssignableFrom(decoderEntry.getDecoderClazz())) {
                    this.binaryDecoders.add(decoderEntry.getDecoderClazz());
                    continue;
                }
                if (Decoder.BinaryStream.class.isAssignableFrom(decoderEntry.getDecoderClazz())) {
                    this.binaryDecoders.add(decoderEntry.getDecoderClazz());
                    break;
                }
                if (Decoder.Text.class.isAssignableFrom(decoderEntry.getDecoderClazz())) {
                    this.textDecoders.add(decoderEntry.getDecoderClazz());
                    continue;
                }
                if (Decoder.TextStream.class.isAssignableFrom(decoderEntry.getDecoderClazz())) {
                    this.textDecoders.add(decoderEntry.getDecoderClazz());
                    break;
                }
                throw new IllegalArgumentException(sm.getString("util.unknownDecoderType"));
            }
        }

        public List<Class<? extends Decoder>> getTextDecoders() {
            return this.textDecoders;
        }

        public List<Class<? extends Decoder>> getBinaryDecoders() {
            return this.binaryDecoders;
        }

        public Class<?> getTarget() {
            return this.target;
        }

        public boolean hasMatches() {
            return !this.textDecoders.isEmpty() || !this.binaryDecoders.isEmpty();
        }
    }
}

