/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.api.ApiGeneratorUtils;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.utils.I18N;

public abstract class AbstractAPIGenerator {
    protected static final String OPTIONAL_MESSAGE = "This component is optional and therefore the API will only work if it is installed";
    protected static final String VIEW_ENDPOINT = "view";
    protected static final String ACTION_ENDPOINT = "action";
    protected static final String OTHER_ENDPOINT = "other";
    private final Path directory;
    private final boolean optional;
    private final ResourceBundle messages;

    protected AbstractAPIGenerator(String directory) {
        this(directory, false);
    }

    protected AbstractAPIGenerator(String directory, boolean optional) {
        this(directory, optional, null);
    }

    protected AbstractAPIGenerator(String directory, boolean optional, ResourceBundle resourceBundle) {
        this.directory = Paths.get(directory, new String[0]);
        this.optional = optional;
        Constant.messages = new I18N(Locale.ENGLISH);
        this.messages = resourceBundle != null ? resourceBundle : Constant.messages.getCoreResourceBundle();
    }

    protected Path getDirectory() {
        return this.directory;
    }

    protected boolean isOptional() {
        return this.optional;
    }

    protected ResourceBundle getMessages() {
        return this.messages;
    }

    public void generateCoreAPIFiles() throws IOException {
        this.generateAPIFiles(ApiGeneratorUtils.getAllImplementors());
    }

    public void generateAPIFiles(List<ApiImplementor> implementors) throws IOException {
        for (ApiImplementor implementor : implementors) {
            this.generateAPIFiles(implementor);
        }
    }

    protected abstract void generateAPIFiles(ApiImplementor var1) throws IOException;
}

