; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -mtriple=nvptx64-nvidia-cuda -passes=infer-address-spaces,bdce %s | FileCheck %s

target datalayout = "e-p:64:64:64-p3:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-i128:128:128-f32:32:32-f64:64:64-v16:16:16-v32:32:32-v64:64:64-v128:128:128-n16:32:64"
target triple = "nvptx64-nvidia-cuda"

declare i1 @llvm.nvvm.isspacep.const(ptr) readnone noinline
declare i1 @llvm.nvvm.isspacep.global(ptr) readnone noinline
declare i1 @llvm.nvvm.isspacep.local(ptr) readnone noinline
declare i1 @llvm.nvvm.isspacep.shared(ptr) readnone noinline
declare i1 @llvm.nvvm.isspacep.cluster.shared(ptr) readnone noinline

define i1 @test_isspacep_const_true(ptr addrspace(4) %addr) {
; CHECK-LABEL: define i1 @test_isspacep_const_true(
; CHECK-SAME: ptr addrspace(4) [[ADDR:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %addr0 = addrspacecast ptr addrspace(4) %addr to ptr
  %addr1 = getelementptr i8, ptr %addr0, i32 10
  %val = call i1 @llvm.nvvm.isspacep.const(ptr %addr1)
  ret i1 %val
}

define i1 @test_isspacep_const_false(ptr addrspace(1) %addr) {
; CHECK-LABEL: define i1 @test_isspacep_const_false(
; CHECK-SAME: ptr addrspace(1) [[ADDR:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret i1 false
;
entry:
  %addr0 = addrspacecast ptr addrspace(1) %addr to ptr
  %addr1 = getelementptr i8, ptr %addr0, i32 10
  %val = call i1 @llvm.nvvm.isspacep.const(ptr %addr1)
  ret i1 %val
}

define i1 @test_isspacep_global_true(ptr addrspace(1) %addr) {
; CHECK-LABEL: define i1 @test_isspacep_global_true(
; CHECK-SAME: ptr addrspace(1) [[ADDR:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %addr0 = addrspacecast ptr addrspace(1) %addr to ptr
  %addr1 = getelementptr i8, ptr %addr0, i32 10
  %val = call i1 @llvm.nvvm.isspacep.global(ptr %addr1)
  ret i1 %val
}

define i1 @test_isspacep_global_false(ptr addrspace(4) %addr) {
; CHECK-LABEL: define i1 @test_isspacep_global_false(
; CHECK-SAME: ptr addrspace(4) [[ADDR:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret i1 false
;
entry:
  %addr0 = addrspacecast ptr addrspace(4) %addr to ptr
  %addr1 = getelementptr i8, ptr %addr0, i32 10
  %val = call i1 @llvm.nvvm.isspacep.global(ptr %addr1)
  ret i1 %val
}

define i1 @test_isspacep_local_true(ptr addrspace(5) %addr) {
; CHECK-LABEL: define i1 @test_isspacep_local_true(
; CHECK-SAME: ptr addrspace(5) [[ADDR:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %addr0 = addrspacecast ptr addrspace(5) %addr to ptr
  %addr1 = getelementptr i8, ptr %addr0, i32 10
  %val = call i1 @llvm.nvvm.isspacep.local(ptr %addr1)
  ret i1 %val
}

define i1 @test_isspacep_local_false(ptr addrspace(1) %addr) {
; CHECK-LABEL: define i1 @test_isspacep_local_false(
; CHECK-SAME: ptr addrspace(1) [[ADDR:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret i1 false
;
entry:
  %addr0 = addrspacecast ptr addrspace(1) %addr to ptr
  %addr1 = getelementptr i8, ptr %addr0, i32 10
  %val = call i1 @llvm.nvvm.isspacep.local(ptr %addr1)
  ret i1 %val
}

define i1 @test_isspacep_shared_true(ptr addrspace(3) %addr) {
; CHECK-LABEL: define i1 @test_isspacep_shared_true(
; CHECK-SAME: ptr addrspace(3) [[ADDR:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %addr0 = addrspacecast ptr addrspace(3) %addr to ptr
  %addr1 = getelementptr i8, ptr %addr0, i32 10
  %val = call i1 @llvm.nvvm.isspacep.shared(ptr %addr1)
  ret i1 %val
}

define i1 @test_isspacep_shared_false(ptr addrspace(1) %addr) {
; CHECK-LABEL: define i1 @test_isspacep_shared_false(
; CHECK-SAME: ptr addrspace(1) [[ADDR:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret i1 false
;
entry:
  %addr0 = addrspacecast ptr addrspace(1) %addr to ptr
  %addr1 = getelementptr i8, ptr %addr0, i32 10
  %val = call i1 @llvm.nvvm.isspacep.shared(ptr %addr1)
  ret i1 %val
}

define i1 @test_isspacep_cluster_shared_unsure(ptr addrspace(3) %addr) {
; CHECK-LABEL: define i1 @test_isspacep_cluster_shared_unsure(
; CHECK-SAME: ptr addrspace(3) [[ADDR:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[ADDR1:%.*]] = getelementptr i8, ptr addrspace(3) [[ADDR]], i32 10
; CHECK-NEXT:    [[TMP0:%.*]] = addrspacecast ptr addrspace(3) [[ADDR1]] to ptr
; CHECK-NEXT:    [[VAL:%.*]] = call i1 @llvm.nvvm.isspacep.shared.cluster(ptr [[TMP0]])
; CHECK-NEXT:    ret i1 [[VAL]]
;
entry:
  %addr0 = addrspacecast ptr addrspace(3) %addr to ptr
  %addr1 = getelementptr i8, ptr %addr0, i32 10
  %val = call i1 @llvm.nvvm.isspacep.shared.cluster(ptr %addr1)
  ret i1 %val
}

define i1 @test_isspacep_cluster_shared_false(ptr addrspace(1) %addr) {
; CHECK-LABEL: define i1 @test_isspacep_cluster_shared_false(
; CHECK-SAME: ptr addrspace(1) [[ADDR:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret i1 false
;
entry:
  %addr0 = addrspacecast ptr addrspace(1) %addr to ptr
  %addr1 = getelementptr i8, ptr %addr0, i32 10
  %val = call i1 @llvm.nvvm.isspacep.shared.cluster(ptr %addr1)
  ret i1 %val
}
