; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=x86_64-- -o - %s| FileCheck %s

; Verify that we support non byte-sized elements, together with variable index.

define void @Legalize_SplitVectorResult_insert_i28(i28 %elt, i16 %idx, ptr %p1, ptr %p2) nounwind {
; CHECK-LABEL: Legalize_SplitVectorResult_insert_i28:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $esi killed $esi def $rsi
; CHECK-NEXT:    xorps %xmm0, %xmm0
; CHECK-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    andl $7, %esi
; CHECK-NEXT:    movl %edi, -40(%rsp,%rsi,4)
; CHECK-NEXT:    movaps {{.*#+}} xmm0 = [268435455,268435455,268435455,268435455]
; CHECK-NEXT:    movaps -{{[0-9]+}}(%rsp), %xmm1
; CHECK-NEXT:    andps %xmm0, %xmm1
; CHECK-NEXT:    andps -{{[0-9]+}}(%rsp), %xmm0
; CHECK-NEXT:    movaps %xmm0, 16(%rcx)
; CHECK-NEXT:    movaps %xmm1, (%rcx)
; CHECK-NEXT:    retq
  %vec1 = insertelement <8 x i28> zeroinitializer, i28 %elt, i16 %idx
  %vec2 = zext <8 x i28> %vec1 to <8 x i32>
  store <8 x i32> %vec2, ptr %p2
  ret void
}

define void @Legalize_SplitVectorResult_extract_i12(i16 %idx, ptr %p1, ptr %p2) nounwind {
; CHECK-LABEL: Legalize_SplitVectorResult_extract_i12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    movaps (%rsi), %xmm0
; CHECK-NEXT:    movaps 16(%rsi), %xmm1
; CHECK-NEXT:    movaps 32(%rsi), %xmm2
; CHECK-NEXT:    movaps 48(%rsi), %xmm3
; CHECK-NEXT:    movaps 64(%rsi), %xmm4
; CHECK-NEXT:    movaps 80(%rsi), %xmm5
; CHECK-NEXT:    movaps 96(%rsi), %xmm6
; CHECK-NEXT:    movaps 112(%rsi), %xmm7
; CHECK-NEXT:    movaps %xmm7, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movaps %xmm6, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movaps %xmm5, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movaps %xmm4, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movaps %xmm3, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movaps %xmm2, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movaps %xmm1, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    movaps %xmm0, -{{[0-9]+}}(%rsp)
; CHECK-NEXT:    andl $63, %edi
; CHECK-NEXT:    movzwl -128(%rsp,%rdi,2), %eax
; CHECK-NEXT:    andl $4095, %eax # imm = 0xFFF
; CHECK-NEXT:    movw %ax, (%rdx)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
  %vec = load <64 x i16>, ptr %p1
  %trunc = trunc <64 x i16> %vec to <64 x i12>
  %elt = extractelement <64 x i12> %trunc, i16 %idx
  store i12 %elt, ptr %p2
  ret void
}
