; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-linux < %s | FileCheck %s

declare dso_local ptr @foo()

define dereferenceable(8) ptr @test1() nounwind {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp foo # TAILCALL
  %ret = tail call ptr @foo()
  ret ptr %ret
}

define ptr @test2() nounwind {
; CHECK-LABEL: test2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp foo # TAILCALL
  %ret = tail call dereferenceable(8)  ptr @foo()
  ret ptr %ret
}

define dereferenceable_or_null(8) ptr @test3() nounwind {
; CHECK-LABEL: test3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp foo # TAILCALL
  %ret = tail call ptr @foo()
  ret ptr %ret
}

define ptr @test4() nounwind {
; CHECK-LABEL: test4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp foo # TAILCALL
  %ret = tail call dereferenceable_or_null(8) ptr @foo()
  ret ptr %ret
}

define align 8 ptr @test5() nounwind {
; CHECK-LABEL: test5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp foo # TAILCALL
  %ret = tail call ptr @foo()
  ret ptr %ret
}

define ptr @test6() nounwind {
; CHECK-LABEL: test6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp foo # TAILCALL
  %ret = tail call align 8 ptr @foo()
  ret ptr %ret
}


define noundef ptr @test7() nounwind {
; CHECK-LABEL: test7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp foo # TAILCALL
  %ret = tail call ptr @foo()
  ret ptr %ret
}

define ptr @test8() nounwind {
; CHECK-LABEL: test8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp foo # TAILCALL
  %ret = tail call noundef ptr @foo()
  ret ptr %ret
}
