; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=instsimplify -march=nvptx64 --mcpu=sm_86 --mattr=+ptx72 -S | FileCheck %s

; Check constant-folding for NVVM fmin fmax intrinsics

;###############################################################
;#                    FMax(1.25, -2.0)                         #
;###############################################################

define double @test_fmax_1_25_neg_2_d() {
; CHECK-LABEL: define double @test_fmax_1_25_neg_2_d() {
; CHECK-NEXT:    ret double 1.250000e+00
;
  %res = call double @llvm.nvvm.fmax.d(double 1.25, double -2.0)
  ret double %res
}

define float @test_fmax_1_25_neg_2_f() {
; CHECK-LABEL: define float @test_fmax_1_25_neg_2_f() {
; CHECK-NEXT:    ret float 1.250000e+00
;
  %res = call float @llvm.nvvm.fmax.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmax_1_25_neg_2_ftz_f() {
; CHECK-LABEL: define float @test_fmax_1_25_neg_2_ftz_f() {
; CHECK-NEXT:    ret float 1.250000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmax_1_25_neg_2_ftz_nan_f() {
; CHECK-LABEL: define float @test_fmax_1_25_neg_2_ftz_nan_f() {
; CHECK-NEXT:    ret float 1.250000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmax_1_25_neg_2_ftz_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_1_25_neg_2_ftz_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float -2.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.xorsign.abs.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmax_1_25_neg_2_ftz_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_1_25_neg_2_ftz_xorsign_abs_f() {
; CHECK-NEXT:    ret float -2.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.xorsign.abs.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmax_1_25_neg_2_nan_f() {
; CHECK-LABEL: define float @test_fmax_1_25_neg_2_nan_f() {
; CHECK-NEXT:    ret float 1.250000e+00
;
  %res = call float @llvm.nvvm.fmax.nan.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmax_1_25_neg_2_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_1_25_neg_2_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float -2.000000e+00
;
  %res = call float @llvm.nvvm.fmax.nan.xorsign.abs.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmax_1_25_neg_2_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_1_25_neg_2_xorsign_abs_f() {
; CHECK-NEXT:    ret float -2.000000e+00
;
  %res = call float @llvm.nvvm.fmax.xorsign.abs.f(float 1.25, float -2.0)
  ret float %res
}

;###############################################################
;#                   FMax(+Subnormal, 0.0)                     #
;###############################################################

define double @test_fmax_pos_subnorm_zero_d() {
; CHECK-LABEL: define double @test_fmax_pos_subnorm_zero_d() {
; CHECK-NEXT:    ret double 0x380FFFFFC0000000
;
  %res = call double @llvm.nvvm.fmax.d(double 0x380FFFFFC0000000, double 0.0)
  ret double %res
}

define float @test_fmax_pos_subnorm_zero_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_zero_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.f(float 0x380FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmax_pos_subnorm_zero_ftz_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_zero_ftz_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.f(float 0x380FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmax_pos_subnorm_zero_ftz_nan_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_zero_ftz_nan_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.f(float 0x380FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmax_pos_subnorm_zero_ftz_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_zero_ftz_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmax_pos_subnorm_zero_ftz_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_zero_ftz_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.xorsign.abs.f(float 0x380FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmax_pos_subnorm_zero_nan_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_zero_nan_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.nan.f(float 0x380FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmax_pos_subnorm_zero_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_zero_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmax_pos_subnorm_zero_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_zero_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.xorsign.abs.f(float 0x380FFFFFC0000000, float 0.0)
  ret float %res
}

;###############################################################
;#                   FMax(+Subnormal, -Subnormal)              #
;###############################################################

define double @test_fmax_pos_subnorm_neg_subnorm_d() {
; CHECK-LABEL: define double @test_fmax_pos_subnorm_neg_subnorm_d() {
; CHECK-NEXT:    ret double 0x380FFFFFC0000000
;
  %res = call double @llvm.nvvm.fmax.d(double 0x380FFFFFC0000000, double 0xB80FFFFFC0000000)
  ret double %res
}

define float @test_fmax_pos_subnorm_neg_subnorm_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_neg_subnorm_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_neg_subnorm_ftz_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_neg_subnorm_ftz_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_neg_subnorm_ftz_nan_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_neg_subnorm_ftz_nan_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_neg_subnorm_ftz_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_neg_subnorm_ftz_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float -0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_neg_subnorm_ftz_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_neg_subnorm_ftz_xorsign_abs_f() {
; CHECK-NEXT:    ret float -0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.xorsign.abs.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_neg_subnorm_nan_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_neg_subnorm_nan_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.nan.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_neg_subnorm_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_neg_subnorm_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0xB80FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_neg_subnorm_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_neg_subnorm_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0xB80FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.xorsign.abs.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

;###############################################################
;#                   FMax(+Subnormal, NaN)                     #
;###############################################################

define double @test_fmax_pos_subnorm_nan_d() {
; CHECK-LABEL: define double @test_fmax_pos_subnorm_nan_d() {
; CHECK-NEXT:    ret double 0x380FFFFFC0000000
;
  %res = call double @llvm.nvvm.fmax.d(double 0x380FFFFFC0000000, double 0x7fff444400000000)
  ret double %res
}

define float @test_fmax_pos_subnorm_nan_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_nan_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_nan_ftz_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_nan_ftz_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_nan_ftz_nan_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_nan_ftz_nan_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_nan_ftz_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_nan_ftz_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_nan_ftz_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_nan_ftz_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.xorsign.abs.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_nan_nan_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_nan_nan_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmax.nan.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_nan_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_nan_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmax.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmax_pos_subnorm_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_pos_subnorm_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.xorsign.abs.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

;###############################################################
;#                   FMax(+Subnormal, undef)                   #
;###############################################################

define double @test_fmax_subnorm_undef_d() {
; CHECK-LABEL: define double @test_fmax_subnorm_undef_d() {
; CHECK-NEXT:    ret double 0x380FFFFFC0000000
;
  %res = call double @llvm.nvvm.fmax.d(double 0x380FFFFFC0000000, double undef)
  ret double %res
}

define float @test_fmax_subnorm_undef_f() {
; CHECK-LABEL: define float @test_fmax_subnorm_undef_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmax_subnorm_undef_ftz_f() {
; CHECK-LABEL: define float @test_fmax_subnorm_undef_ftz_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmax_subnorm_undef_ftz_nan_f() {
; CHECK-LABEL: define float @test_fmax_subnorm_undef_ftz_nan_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmax_subnorm_undef_ftz_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_subnorm_undef_ftz_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmax_subnorm_undef_ftz_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_subnorm_undef_ftz_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmax.ftz.xorsign.abs.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmax_subnorm_undef_nan_f() {
; CHECK-LABEL: define float @test_fmax_subnorm_undef_nan_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.nan.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmax_subnorm_undef_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_subnorm_undef_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmax_subnorm_undef_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_subnorm_undef_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmax.xorsign.abs.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

;###############################################################
;#                      FMax(NaN, undef)                       #
;###############################################################
; Ensure we canonicalize the NaNs for f32

define double @test_fmax_nan_undef_d() {
; CHECK-LABEL: define double @test_fmax_nan_undef_d() {
; CHECK-NEXT:    ret double 0x7FF4444400000000
;
  %res = call double @llvm.nvvm.fmax.d(double 0x7ff4444400000000, double undef)
  ret double %res
}

define float @test_fmax_nan_undef_f() {
; CHECK-LABEL: define float @test_fmax_nan_undef_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmax.f(float 0x7fff444400000000, float undef)
  ret float %res
}

define float @test_fmax_nan_undef_ftz_f() {
; CHECK-LABEL: define float @test_fmax_nan_undef_ftz_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmax.ftz.f(float 0x7fff444400000000, float undef)
  ret float %res
}

define float @test_fmax_nan_undef_ftz_nan_f() {
; CHECK-LABEL: define float @test_fmax_nan_undef_ftz_nan_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.f(float 0x7fff444400000000, float undef)
  ret float %res
}

define float @test_fmax_nan_undef_ftz_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_nan_undef_ftz_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmax.ftz.nan.xorsign.abs.f(float 0x7fff444400000000, float undef)
  ret float %res
}

define float @test_fmax_nan_undef_ftz_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_nan_undef_ftz_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmax.ftz.xorsign.abs.f(float 0x7ffff4ff00000000, float undef)
  ret float %res
}

define float @test_fmax_nan_undef_nan_f() {
; CHECK-LABEL: define float @test_fmax_nan_undef_nan_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmax.nan.f(float 0x7fff444400000000, float undef)
  ret float %res
}

define float @test_fmax_nan_undef_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_nan_undef_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmax.nan.xorsign.abs.f(float 0x7fff444400000000, float undef)
  ret float %res
}

define float @test_fmax_nan_undef_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmax_nan_undef_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmax.xorsign.abs.f(float 0x7fff444400000000, float undef)
  ret float %res
}

;###############################################################
;#                    FMin(1.25, -2.0)                         #
;###############################################################

define double @test_fmin_1_25_neg_2_d() {
; CHECK-LABEL: define double @test_fmin_1_25_neg_2_d() {
; CHECK-NEXT:    ret double -2.000000e+00
;
  %res = call double @llvm.nvvm.fmin.d(double 1.25, double -2.0)
  ret double %res
}

define float @test_fmin_1_25_neg_2_f() {
; CHECK-LABEL: define float @test_fmin_1_25_neg_2_f() {
; CHECK-NEXT:    ret float -2.000000e+00
;
  %res = call float @llvm.nvvm.fmin.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmin_1_25_neg_2_ftz_f() {
; CHECK-LABEL: define float @test_fmin_1_25_neg_2_ftz_f() {
; CHECK-NEXT:    ret float -2.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmin_1_25_neg_2_ftz_nan_f() {
; CHECK-LABEL: define float @test_fmin_1_25_neg_2_ftz_nan_f() {
; CHECK-NEXT:    ret float -2.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.nan.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmin_1_25_neg_2_ftz_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_1_25_neg_2_ftz_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float -1.250000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.nan.xorsign.abs.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmin_1_25_neg_2_ftz_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_1_25_neg_2_ftz_xorsign_abs_f() {
; CHECK-NEXT:    ret float -1.250000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.xorsign.abs.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmin_1_25_neg_2_nan_f() {
; CHECK-LABEL: define float @test_fmin_1_25_neg_2_nan_f() {
; CHECK-NEXT:    ret float -2.000000e+00
;
  %res = call float @llvm.nvvm.fmin.nan.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmin_1_25_neg_2_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_1_25_neg_2_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float -1.250000e+00
;
  %res = call float @llvm.nvvm.fmin.nan.xorsign.abs.f(float 1.25, float -2.0)
  ret float %res
}

define float @test_fmin_1_25_neg_2_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_1_25_neg_2_xorsign_abs_f() {
; CHECK-NEXT:    ret float -1.250000e+00
;
  %res = call float @llvm.nvvm.fmin.xorsign.abs.f(float 1.25, float -2.0)
  ret float %res
}

;###############################################################
;#                   FMin(-Subnormal, 0.0)                     #
;###############################################################

define double @test_fmin_neg_subnorm_zero_d() {
; CHECK-LABEL: define double @test_fmin_neg_subnorm_zero_d() {
; CHECK-NEXT:    ret double 0xB80FFFFFC0000000
;
  %res = call double @llvm.nvvm.fmin.d(double 0xB80FFFFFC0000000, double 0.0)
  ret double %res
}

define float @test_fmin_neg_subnorm_zero_f() {
; CHECK-LABEL: define float @test_fmin_neg_subnorm_zero_f() {
; CHECK-NEXT:    ret float 0xB80FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmin.f(float 0xB80FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmin_neg_subnorm_zero_ftz_f() {
; CHECK-LABEL: define float @test_fmin_neg_subnorm_zero_ftz_f() {
; CHECK-NEXT:    ret float -0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.f(float 0xB80FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmin_neg_subnorm_zero_ftz_nan_f() {
; CHECK-LABEL: define float @test_fmin_neg_subnorm_zero_ftz_nan_f() {
; CHECK-NEXT:    ret float -0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.nan.f(float 0xB80FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmin_neg_subnorm_zero_ftz_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_neg_subnorm_zero_ftz_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float -0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.nan.xorsign.abs.f(float 0xB80FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmin_neg_subnorm_zero_ftz_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_neg_subnorm_zero_ftz_xorsign_abs_f() {
; CHECK-NEXT:    ret float -0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.xorsign.abs.f(float 0xB80FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmin_neg_subnorm_zero_nan_f() {
; CHECK-LABEL: define float @test_fmin_neg_subnorm_zero_nan_f() {
; CHECK-NEXT:    ret float 0xB80FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmin.nan.f(float 0xB80FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmin_neg_subnorm_zero_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_neg_subnorm_zero_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float -0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.nan.xorsign.abs.f(float 0xB80FFFFFC0000000, float 0.0)
  ret float %res
}

define float @test_fmin_neg_subnorm_zero_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_neg_subnorm_zero_xorsign_abs_f() {
; CHECK-NEXT:    ret float -0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.xorsign.abs.f(float 0xB80FFFFFC0000000, float 0.0)
  ret float %res
}

;###############################################################
;#                   FMin(+Subnormal, -Subnormal)              #
;###############################################################

define double @test_fmin_pos_subnorm_neg_subnorm_d() {
; CHECK-LABEL: define double @test_fmin_pos_subnorm_neg_subnorm_d() {
; CHECK-NEXT:    ret double 0xB80FFFFFC0000000
;
  %res = call double @llvm.nvvm.fmin.d(double 0x380FFFFFC0000000, double 0xB80FFFFFC0000000)
  ret double %res
}

define float @test_fmin_pos_subnorm_neg_subnorm_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_neg_subnorm_f() {
; CHECK-NEXT:    ret float 0xB80FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmin.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_neg_subnorm_ftz_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_neg_subnorm_ftz_f() {
; CHECK-NEXT:    ret float -0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_neg_subnorm_ftz_nan_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_neg_subnorm_ftz_nan_f() {
; CHECK-NEXT:    ret float -0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.nan.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_neg_subnorm_ftz_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_neg_subnorm_ftz_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float -0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_neg_subnorm_ftz_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_neg_subnorm_ftz_xorsign_abs_f() {
; CHECK-NEXT:    ret float -0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.xorsign.abs.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_neg_subnorm_nan_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_neg_subnorm_nan_f() {
; CHECK-NEXT:    ret float 0xB80FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmin.nan.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_neg_subnorm_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_neg_subnorm_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0xB80FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmin.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_neg_subnorm_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_neg_subnorm_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0xB80FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmin.xorsign.abs.f(float 0x380FFFFFC0000000, float 0xB80FFFFFC0000000)
  ret float %res
}

;###############################################################
;#                   FMin(+Subnormal, NaN)                     #
;###############################################################

define double @test_fmin_pos_subnorm_nan_d() {
; CHECK-LABEL: define double @test_fmin_pos_subnorm_nan_d() {
; CHECK-NEXT:    ret double 0x380FFFFFC0000000
;
  %res = call double @llvm.nvvm.fmin.d(double 0x380FFFFFC0000000, double 0x7fff444400000000)
  ret double %res
}

define float @test_fmin_pos_subnorm_nan_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_nan_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmin.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_nan_ftz_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_nan_ftz_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_nan_ftz_nan_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_nan_ftz_nan_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmin.ftz.nan.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_nan_ftz_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_nan_ftz_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmin.ftz.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_nan_ftz_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_nan_ftz_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.xorsign.abs.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_nan_nan_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_nan_nan_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmin.nan.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_nan_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_nan_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmin.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

define float @test_fmin_pos_subnorm_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_pos_subnorm_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmin.xorsign.abs.f(float 0x380FFFFFC0000000, float 0x7fff444400000000)
  ret float %res
}

;###############################################################
;#                   FMin(+Subnormal, undef)                   #
;###############################################################

define double @test_fmin_subnorm_undef_d() {
; CHECK-LABEL: define double @test_fmin_subnorm_undef_d() {
; CHECK-NEXT:    ret double 0x380FFFFFC0000000
;
  %res = call double @llvm.nvvm.fmin.d(double 0x380FFFFFC0000000, double undef)
  ret double %res
}

define float @test_fmin_subnorm_undef_f() {
; CHECK-LABEL: define float @test_fmin_subnorm_undef_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmin.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmin_subnorm_undef_ftz_f() {
; CHECK-LABEL: define float @test_fmin_subnorm_undef_ftz_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmin_subnorm_undef_ftz_nan_f() {
; CHECK-LABEL: define float @test_fmin_subnorm_undef_ftz_nan_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.nan.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmin_subnorm_undef_ftz_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_subnorm_undef_ftz_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmin_subnorm_undef_ftz_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_subnorm_undef_ftz_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %res = call float @llvm.nvvm.fmin.ftz.xorsign.abs.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmin_subnorm_undef_nan_f() {
; CHECK-LABEL: define float @test_fmin_subnorm_undef_nan_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmin.nan.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmin_subnorm_undef_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_subnorm_undef_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmin.nan.xorsign.abs.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

define float @test_fmin_subnorm_undef_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_subnorm_undef_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x380FFFFFC0000000
;
  %res = call float @llvm.nvvm.fmin.xorsign.abs.f(float 0x380FFFFFC0000000, float undef)
  ret float %res
}

;###############################################################
;#                      FMin(NaN, undef)                       #
;###############################################################
; Ensure we canonicalize the NaNs for f32

define double @test_fmin_nan_undef_d() {
; CHECK-LABEL: define double @test_fmin_nan_undef_d() {
; CHECK-NEXT:    ret double 0x7FF4444400000000
;
  %res = call double @llvm.nvvm.fmin.d(double 0x7ff4444400000000, double undef)
  ret double %res
}

define float @test_fmin_nan_undef_f() {
; CHECK-LABEL: define float @test_fmin_nan_undef_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmin.f(float 0x7fff444400000000, float undef)
  ret float %res
}

define float @test_fmin_nan_undef_ftz_f() {
; CHECK-LABEL: define float @test_fmin_nan_undef_ftz_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmin.ftz.f(float 0x7fff444400000000, float undef)
  ret float %res
}

define float @test_fmin_nan_undef_ftz_nan_f() {
; CHECK-LABEL: define float @test_fmin_nan_undef_ftz_nan_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmin.ftz.nan.f(float 0x7fff444400000000, float undef)
  ret float %res
}

define float @test_fmin_nan_undef_ftz_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_nan_undef_ftz_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmin.ftz.nan.xorsign.abs.f(float 0x7fff444400000000, float undef)
  ret float %res
}

define float @test_fmin_nan_undef_ftz_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_nan_undef_ftz_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmin.ftz.xorsign.abs.f(float 0x7ffff4ff00000000, float undef)
  ret float %res
}

define float @test_fmin_nan_undef_nan_f() {
; CHECK-LABEL: define float @test_fmin_nan_undef_nan_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmin.nan.f(float 0x7fff444400000000, float undef)
  ret float %res
}

define float @test_fmin_nan_undef_nan_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_nan_undef_nan_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmin.nan.xorsign.abs.f(float 0x7fff444400000000, float undef)
  ret float %res
}

define float @test_fmin_nan_undef_xorsign_abs_f() {
; CHECK-LABEL: define float @test_fmin_nan_undef_xorsign_abs_f() {
; CHECK-NEXT:    ret float 0x7FFFFFFFE0000000
;
  %res = call float @llvm.nvvm.fmin.xorsign.abs.f(float 0x7fff444400000000, float undef)
  ret float %res
}
