; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx900 %s -o - | FileCheck %s

define float @test_fmamix_constant_bus_violation_sss(i32 inreg %val.0, i32 inreg %val.1, i32 inreg %val.2) #0 {
; CHECK-LABEL: test_fmamix_constant_bus_violation_sss:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    s_lshr_b32 s5, s17, 16
; CHECK-NEXT:    s_lshr_b32 s6, s18, 16
; CHECK-NEXT:    s_lshr_b32 s4, s16, 16
; CHECK-NEXT:    v_mov_b32_e32 v0, s5
; CHECK-NEXT:    v_mov_b32_e32 v1, s6
; CHECK-NEXT:    v_mad_mix_f32 v0, s4, v0, v1 op_sel_hi:[1,1,1]
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %lshr.0 = lshr i32 %val.0, 16
  %lshr.1 = lshr i32 %val.1, 16
  %lshr.2 = lshr i32 %val.2, 16
  %trunc.0 = trunc i32 %lshr.0 to i16
  %trunc.1 = trunc i32 %lshr.1 to i16
  %trunc.2 = trunc i32 %lshr.2 to i16
  %cast.0 = bitcast i16 %trunc.0 to half
  %cast.1 = bitcast i16 %trunc.1 to half
  %cast.2 = bitcast i16 %trunc.2 to half
  %fpext.0 = fpext half %cast.0 to float
  %fpext.1 = fpext half %cast.1 to float
  %fpext.2 = fpext half %cast.2 to float
  %fma = call float @llvm.fmuladd.f32(float %fpext.0, float %fpext.1, float %fpext.2)
  ret float %fma
}

define float @test_fmamix_constant_bus_violation_ssv(i32 inreg %val.0, i32 inreg %val.1, i32 %val.2) #0 {
; CHECK-LABEL: test_fmamix_constant_bus_violation_ssv:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    s_lshr_b32 s5, s17, 16
; CHECK-NEXT:    s_lshr_b32 s4, s16, 16
; CHECK-NEXT:    v_mov_b32_e32 v1, s5
; CHECK-NEXT:    v_mad_mix_f32 v0, s4, v1, v0 op_sel:[0,0,1] op_sel_hi:[1,1,1]
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %lshr.0 = lshr i32 %val.0, 16
  %lshr.1 = lshr i32 %val.1, 16
  %lshr.2 = lshr i32 %val.2, 16
  %trunc.0 = trunc i32 %lshr.0 to i16
  %trunc.1 = trunc i32 %lshr.1 to i16
  %trunc.2 = trunc i32 %lshr.2 to i16
  %cast.0 = bitcast i16 %trunc.0 to half
  %cast.1 = bitcast i16 %trunc.1 to half
  %cast.2 = bitcast i16 %trunc.2 to half
  %fpext.0 = fpext half %cast.0 to float
  %fpext.1 = fpext half %cast.1 to float
  %fpext.2 = fpext half %cast.2 to float
  %fma = call float @llvm.fmuladd.f32(float %fpext.0, float %fpext.1, float %fpext.2)
  ret float %fma
}

define float @test_fmamix_constant_bus_violation_svs(i32 inreg %val.0, i32 %val.1, i32 inreg %val.2) #0 {
; CHECK-LABEL: test_fmamix_constant_bus_violation_svs:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    s_lshr_b32 s5, s17, 16
; CHECK-NEXT:    s_lshr_b32 s4, s16, 16
; CHECK-NEXT:    v_mov_b32_e32 v1, s5
; CHECK-NEXT:    v_mad_mix_f32 v0, s4, v0, v1 op_sel:[0,1,0] op_sel_hi:[1,1,1]
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %lshr.0 = lshr i32 %val.0, 16
  %lshr.1 = lshr i32 %val.1, 16
  %lshr.2 = lshr i32 %val.2, 16
  %trunc.0 = trunc i32 %lshr.0 to i16
  %trunc.1 = trunc i32 %lshr.1 to i16
  %trunc.2 = trunc i32 %lshr.2 to i16
  %cast.0 = bitcast i16 %trunc.0 to half
  %cast.1 = bitcast i16 %trunc.1 to half
  %cast.2 = bitcast i16 %trunc.2 to half
  %fpext.0 = fpext half %cast.0 to float
  %fpext.1 = fpext half %cast.1 to float
  %fpext.2 = fpext half %cast.2 to float
  %fma = call float @llvm.fmuladd.f32(float %fpext.0, float %fpext.1, float %fpext.2)
  ret float %fma
}

define float @test_fmamix_constant_bus_violation_vss(i32 %val.0, i32 inreg %val.1, i32 inreg %val.2) #0 {
; CHECK-LABEL: test_fmamix_constant_bus_violation_vss:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    s_lshr_b32 s5, s17, 16
; CHECK-NEXT:    s_lshr_b32 s4, s16, 16
; CHECK-NEXT:    v_mov_b32_e32 v1, s5
; CHECK-NEXT:    v_mad_mix_f32 v0, v0, s4, v1 op_sel:[1,0,0] op_sel_hi:[1,1,1]
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %lshr.0 = lshr i32 %val.0, 16
  %lshr.1 = lshr i32 %val.1, 16
  %lshr.2 = lshr i32 %val.2, 16
  %trunc.0 = trunc i32 %lshr.0 to i16
  %trunc.1 = trunc i32 %lshr.1 to i16
  %trunc.2 = trunc i32 %lshr.2 to i16
  %cast.0 = bitcast i16 %trunc.0 to half
  %cast.1 = bitcast i16 %trunc.1 to half
  %cast.2 = bitcast i16 %trunc.2 to half
  %fpext.0 = fpext half %cast.0 to float
  %fpext.1 = fpext half %cast.1 to float
  %fpext.2 = fpext half %cast.2 to float
  %fma = call float @llvm.fmuladd.f32(float %fpext.0, float %fpext.1, float %fpext.2)
  ret float %fma
}

attributes #0 = { "denormal-fp-math-f32"="preserve-sign" }
