; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=loongarch64 -mattr=+lasx < %s | FileCheck %s

;; 1. trunc(abs(sub(sext(a),sext(b)))) -> abds(a,b) or abdu(a,b)
;; 2. abs(sub_nsw(x, y)) -> abds(a,b)
;; 3. sub(smax(a,b),smin(a,b)) -> abds(a,b) or abdu(a,b)
;; 4. select(icmp(a,b, slt|ult),sub(a,b),sub(b,a)) -> abds(a,b) or abdu(a,b)
;; 5. sub(select(icmp(a,b),a,b),select(icmp(a,b),b,a)) -> abds(a,b) or abdu(a,b)
;;
;; abds / abdu can be lowered to xvabsd.{b/h/w/d} / xvabsd.{b/h/w/d}u  instruction.

;; trunc(abs(sub(sext(a),sext(b)))) -> abds(a,b)
define <32 x i8> @xvabsd_b(<32 x i8> %a, <32 x i8> %b) {
; CHECK-LABEL: xvabsd_b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.b $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a.sext = sext <32 x i8> %a to <32 x i16>
  %b.sext = sext <32 x i8> %b to <32 x i16>
  %sub = sub <32 x i16> %a.sext, %b.sext
  %abs = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %sub, i1 true)
  %trunc = trunc <32 x i16> %abs to <32 x i8>
  ret <32 x i8> %trunc
}

define <16 x i16> @xvabsd_h(<16 x i16> %a, <16 x i16> %b) {
; CHECK-LABEL: xvabsd_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.h $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a.sext = sext <16 x i16> %a to <16 x i32>
  %b.sext = sext <16 x i16> %b to <16 x i32>
  %sub = sub <16 x i32> %a.sext, %b.sext
  %abs = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %sub, i1 true)
  %trunc = trunc <16 x i32> %abs to <16 x i16>
  ret <16 x i16> %trunc
}

define <8 x i32> @xvabsd_w(<8 x i32> %a, <8 x i32> %b) {
; CHECK-LABEL: xvabsd_w:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.w $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a.sext = sext <8 x i32> %a to <8 x i64>
  %b.sext = sext <8 x i32> %b to <8 x i64>
  %sub = sub <8 x i64> %a.sext, %b.sext
  %abs = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %sub, i1 true)
  %trunc = trunc <8 x i64> %abs to <8 x i32>
  ret <8 x i32> %trunc
}

define <4 x i64> @xvabsd_d(<4 x i64> %a, <4 x i64> %b) {
; CHECK-LABEL: xvabsd_d:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.d $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a.sext = sext <4 x i64> %a to <4 x i128>
  %b.sext = sext <4 x i64> %b to <4 x i128>
  %sub = sub <4 x i128> %a.sext, %b.sext
  %abs = call <4 x i128> @llvm.abs.v4i128(<4 x i128> %sub, i1 true)
  %trunc = trunc <4 x i128> %abs to <4 x i64>
  ret <4 x i64> %trunc
}

define <32 x i8> @xvabsd_bu(<32 x i8> %a, <32 x i8> %b) {
; CHECK-LABEL: xvabsd_bu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.bu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a.zext = zext <32 x i8> %a to <32 x i16>
  %b.zext = zext <32 x i8> %b to <32 x i16>
  %sub = sub <32 x i16> %a.zext, %b.zext
  %abs = call <32 x i16> @llvm.abs.v32i16(<32 x i16> %sub, i1 true)
  %trunc = trunc <32 x i16> %abs to <32 x i8>
  ret <32 x i8> %trunc
}

define <16 x i16> @xvabsd_hu(<16 x i16> %a, <16 x i16> %b) {
; CHECK-LABEL: xvabsd_hu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.hu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a.zext = zext <16 x i16> %a to <16 x i32>
  %b.zext = zext <16 x i16> %b to <16 x i32>
  %sub = sub <16 x i32> %a.zext, %b.zext
  %abs = call <16 x i32> @llvm.abs.v16i32(<16 x i32> %sub, i1 true)
  %trunc = trunc <16 x i32> %abs to <16 x i16>
  ret <16 x i16> %trunc
}

define <8 x i32> @xvabsd_wu(<8 x i32> %a, <8 x i32> %b) {
; CHECK-LABEL: xvabsd_wu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.wu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a.zext = zext <8 x i32> %a to <8 x i64>
  %b.zext = zext <8 x i32> %b to <8 x i64>
  %sub = sub <8 x i64> %a.zext, %b.zext
  %abs = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %sub, i1 true)
  %trunc = trunc <8 x i64> %abs to <8 x i32>
  ret <8 x i32> %trunc
}

define <4 x i64> @xvabsd_du(<4 x i64> %a, <4 x i64> %b) {
; CHECK-LABEL: xvabsd_du:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.du $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a.zext = zext <4 x i64> %a to <4 x i128>
  %b.zext = zext <4 x i64> %b to <4 x i128>
  %sub = sub <4 x i128> %a.zext, %b.zext
  %abs = call <4 x i128> @llvm.abs.v4i128(<4 x i128> %sub, i1 true)
  %trunc = trunc <4 x i128> %abs to <4 x i64>
  ret <4 x i64> %trunc
}

;; abs(sub_nsw(x, y)) -> abds(a,b)
define <32 x i8> @xvabsd_b_nsw(<32 x i8> %a, <32 x i8> %b) {
; CHECK-LABEL: xvabsd_b_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.b $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %sub = sub nsw <32 x i8> %a, %b
  %abs = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %sub, i1 true)
  ret <32 x i8> %abs
}

define <16 x i16> @xvabsd_h_nsw(<16 x i16> %a, <16 x i16> %b) {
; CHECK-LABEL: xvabsd_h_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.h $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %sub = sub nsw <16 x i16> %a, %b
  %abs = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %sub, i1 true)
  ret <16 x i16> %abs
}

define <8 x i32> @xvabsd_w_nsw(<8 x i32> %a, <8 x i32> %b) {
; CHECK-LABEL: xvabsd_w_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.w $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %sub = sub nsw <8 x i32> %a, %b
  %abs = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %sub, i1 true)
  ret <8 x i32> %abs
}

define <4 x i64> @xvabsd_d_nsw(<4 x i64> %a, <4 x i64> %b) {
; CHECK-LABEL: xvabsd_d_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.d $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %sub = sub nsw <4 x i64> %a, %b
  %abs = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %sub, i1 true)
  ret <4 x i64> %abs
}

;; sub(smax(a,b),smin(a,b)) -> abds(a,b)
define <32 x i8> @maxmin_b(<32 x i8> %0, <32 x i8> %1) {
; CHECK-LABEL: maxmin_b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.b $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a = tail call <32 x i8> @llvm.smax.v32i8(<32 x i8> %0, <32 x i8> %1)
  %b = tail call <32 x i8> @llvm.smin.v32i8(<32 x i8> %0, <32 x i8> %1)
  %sub = sub <32 x i8> %a, %b
  ret <32 x i8> %sub
}

define <16 x i16> @maxmin_h(<16 x i16> %0, <16 x i16> %1) {
; CHECK-LABEL: maxmin_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.h $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a = tail call <16 x i16> @llvm.smax.v16i16(<16 x i16> %0, <16 x i16> %1)
  %b = tail call <16 x i16> @llvm.smin.v16i16(<16 x i16> %0, <16 x i16> %1)
  %sub = sub <16 x i16> %a, %b
  ret <16 x i16> %sub
}

define <8 x i32> @maxmin_w(<8 x i32> %0, <8 x i32> %1) {
; CHECK-LABEL: maxmin_w:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.w $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a = tail call <8 x i32> @llvm.smax.v8i32(<8 x i32> %0, <8 x i32> %1)
  %b = tail call <8 x i32> @llvm.smin.v8i32(<8 x i32> %0, <8 x i32> %1)
  %sub = sub <8 x i32> %a, %b
  ret <8 x i32> %sub
}

define <4 x i64> @maxmin_d(<4 x i64> %0, <4 x i64> %1) {
; CHECK-LABEL: maxmin_d:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.d $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a = tail call <4 x i64> @llvm.smax.v4i64(<4 x i64> %0, <4 x i64> %1)
  %b = tail call <4 x i64> @llvm.smin.v4i64(<4 x i64> %0, <4 x i64> %1)
  %sub = sub <4 x i64> %a, %b
  ret <4 x i64> %sub
}

define <32 x i8> @maxmin_bu(<32 x i8> %0, <32 x i8> %1) {
; CHECK-LABEL: maxmin_bu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.bu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a = tail call <32 x i8> @llvm.umax.v32i8(<32 x i8> %0, <32 x i8> %1)
  %b = tail call <32 x i8> @llvm.umin.v32i8(<32 x i8> %0, <32 x i8> %1)
  %sub = sub <32 x i8> %a, %b
  ret <32 x i8> %sub
}

define <16 x i16> @maxmin_hu(<16 x i16> %0, <16 x i16> %1) {
; CHECK-LABEL: maxmin_hu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.hu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a = tail call <16 x i16> @llvm.umax.v16i16(<16 x i16> %0, <16 x i16> %1)
  %b = tail call <16 x i16> @llvm.umin.v16i16(<16 x i16> %0, <16 x i16> %1)
  %sub = sub <16 x i16> %a, %b
  ret <16 x i16> %sub
}

define <8 x i32> @maxmin_wu(<8 x i32> %0, <8 x i32> %1) {
; CHECK-LABEL: maxmin_wu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.wu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a = tail call <8 x i32> @llvm.umax.v8i32(<8 x i32> %0, <8 x i32> %1)
  %b = tail call <8 x i32> @llvm.umin.v8i32(<8 x i32> %0, <8 x i32> %1)
  %sub = sub <8 x i32> %a, %b
  ret <8 x i32> %sub
}

define <4 x i64> @maxmin_du(<4 x i64> %0, <4 x i64> %1) {
; CHECK-LABEL: maxmin_du:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.du $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a = tail call <4 x i64> @llvm.umax.v4i64(<4 x i64> %0, <4 x i64> %1)
  %b = tail call <4 x i64> @llvm.umin.v4i64(<4 x i64> %0, <4 x i64> %1)
  %sub = sub <4 x i64> %a, %b
  ret <4 x i64> %sub
}

define <32 x i8> @maxmin_bu_com1(<32 x i8> %0, <32 x i8> %1) {
; CHECK-LABEL: maxmin_bu_com1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.bu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %a = tail call <32 x i8> @llvm.umax.v32i8(<32 x i8> %0, <32 x i8> %1)
  %b = tail call <32 x i8> @llvm.umin.v32i8(<32 x i8> %1, <32 x i8> %0)
  %sub = sub <32 x i8> %a, %b
  ret <32 x i8> %sub
}

;; select(icmp(a,b, slt),sub(a,b),sub(b,a)) -> abds(a,b)
define <32 x i8> @xvabsd_b_cmp(<32 x i8> %a, <32 x i8> %b) nounwind {
; CHECK-LABEL: xvabsd_b_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.b $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp slt <32 x i8> %a, %b
  %ab = sub <32 x i8> %a, %b
  %ba = sub <32 x i8> %b, %a
  %sel = select <32 x i1> %cmp, <32 x i8> %ba, <32 x i8> %ab
  ret <32 x i8> %sel
}

define <16 x i16> @xvabsd_h_cmp(<16 x i16> %a, <16 x i16> %b) nounwind {
; CHECK-LABEL: xvabsd_h_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.h $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp slt <16 x i16> %a, %b
  %ab = sub <16 x i16> %a, %b
  %ba = sub <16 x i16> %b, %a
  %sel = select <16 x i1> %cmp, <16 x i16> %ba, <16 x i16> %ab
  ret <16 x i16> %sel
}

define <8 x i32> @xvabsd_w_cmp(<8 x i32> %a, <8 x i32> %b) nounwind {
; CHECK-LABEL: xvabsd_w_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.w $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp slt <8 x i32> %a, %b
  %ab = sub <8 x i32> %a, %b
  %ba = sub <8 x i32> %b, %a
  %sel = select <8 x i1> %cmp, <8 x i32> %ba, <8 x i32> %ab
  ret <8 x i32> %sel
}

define <4 x i64> @xvabsd_d_cmp(<4 x i64> %a, <4 x i64> %b) nounwind {
; CHECK-LABEL: xvabsd_d_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.d $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp slt <4 x i64> %a, %b
  %ab = sub <4 x i64> %a, %b
  %ba = sub <4 x i64> %b, %a
  %sel = select <4 x i1> %cmp, <4 x i64> %ba, <4 x i64> %ab
  ret <4 x i64> %sel
}

define <32 x i8> @xvabsd_bu_cmp(<32 x i8> %a, <32 x i8> %b) nounwind {
; CHECK-LABEL: xvabsd_bu_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.bu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp ult <32 x i8> %a, %b
  %ab = sub <32 x i8> %a, %b
  %ba = sub <32 x i8> %b, %a
  %sel = select <32 x i1> %cmp, <32 x i8> %ba, <32 x i8> %ab
  ret <32 x i8> %sel
}

define <16 x i16> @xvabsd_hu_cmp(<16 x i16> %a, <16 x i16> %b) nounwind {
; CHECK-LABEL: xvabsd_hu_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.hu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp ult <16 x i16> %a, %b
  %ab = sub <16 x i16> %a, %b
  %ba = sub <16 x i16> %b, %a
  %sel = select <16 x i1> %cmp, <16 x i16> %ba, <16 x i16> %ab
  ret <16 x i16> %sel
}

define <8 x i32> @xvabsd_wu_cmp(<8 x i32> %a, <8 x i32> %b) nounwind {
; CHECK-LABEL: xvabsd_wu_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.wu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp ult <8 x i32> %a, %b
  %ab = sub <8 x i32> %a, %b
  %ba = sub <8 x i32> %b, %a
  %sel = select <8 x i1> %cmp, <8 x i32> %ba, <8 x i32> %ab
  ret <8 x i32> %sel
}

define <4 x i64> @xvabsd_du_cmp(<4 x i64> %a, <4 x i64> %b) nounwind {
; CHECK-LABEL: xvabsd_du_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.du $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp ult <4 x i64> %a, %b
  %ab = sub <4 x i64> %a, %b
  %ba = sub <4 x i64> %b, %a
  %sel = select <4 x i1> %cmp, <4 x i64> %ba, <4 x i64> %ab
  ret <4 x i64> %sel
}

;; sub(select(icmp(a,b, slt),a,b),select(icmp(a,b, slt),b,a)) -> abds(a,b)
define <32 x i8> @xvabsd_b_select(<32 x i8> %a, <32 x i8> %b) nounwind {
; CHECK-LABEL: xvabsd_b_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.b $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp slt <32 x i8> %a, %b
  %ab = select <32 x i1> %cmp, <32 x i8> %a, <32 x i8> %b
  %ba = select <32 x i1> %cmp, <32 x i8> %b, <32 x i8> %a
  %sub = sub <32 x i8> %ba, %ab
  ret <32 x i8> %sub
}

define <16 x i16> @xvabsd_h_select(<16 x i16> %a, <16 x i16> %b) nounwind {
; CHECK-LABEL: xvabsd_h_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.h $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp sle <16 x i16> %a, %b
  %ab = select <16 x i1> %cmp, <16 x i16> %a, <16 x i16> %b
  %ba = select <16 x i1> %cmp, <16 x i16> %b, <16 x i16> %a
  %sub = sub <16 x i16> %ba, %ab
  ret <16 x i16> %sub
}

define <8 x i32> @xvabsd_w_select(<8 x i32> %a, <8 x i32> %b) nounwind {
; CHECK-LABEL: xvabsd_w_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.w $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp sgt <8 x i32> %a, %b
  %ab = select <8 x i1> %cmp, <8 x i32> %a, <8 x i32> %b
  %ba = select <8 x i1> %cmp, <8 x i32> %b, <8 x i32> %a
  %sub = sub <8 x i32> %ab, %ba
  ret <8 x i32> %sub
}

define <4 x i64> @xvabsd_d_select(<4 x i64> %a, <4 x i64> %b) nounwind {
; CHECK-LABEL: xvabsd_d_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.d $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp sge <4 x i64> %a, %b
  %ab = select <4 x i1> %cmp, <4 x i64> %a, <4 x i64> %b
  %ba = select <4 x i1> %cmp, <4 x i64> %b, <4 x i64> %a
  %sub = sub <4 x i64> %ab, %ba
  ret <4 x i64> %sub
}

define <32 x i8> @xvabsd_bu_select(<32 x i8> %a, <32 x i8> %b) nounwind {
; CHECK-LABEL: xvabsd_bu_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.bu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp ult <32 x i8> %a, %b
  %ab = select <32 x i1> %cmp, <32 x i8> %a, <32 x i8> %b
  %ba = select <32 x i1> %cmp, <32 x i8> %b, <32 x i8> %a
  %sub = sub <32 x i8> %ba, %ab
  ret <32 x i8> %sub
}

define <16 x i16> @xvabsd_hu_select(<16 x i16> %a, <16 x i16> %b) nounwind {
; CHECK-LABEL: xvabsd_hu_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.hu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp ule <16 x i16> %a, %b
  %ab = select <16 x i1> %cmp, <16 x i16> %a, <16 x i16> %b
  %ba = select <16 x i1> %cmp, <16 x i16> %b, <16 x i16> %a
  %sub = sub <16 x i16> %ba, %ab
  ret <16 x i16> %sub
}

define <8 x i32> @xvabsd_wu_select(<8 x i32> %a, <8 x i32> %b) nounwind {
; CHECK-LABEL: xvabsd_wu_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.wu $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp ugt <8 x i32> %a, %b
  %ab = select <8 x i1> %cmp, <8 x i32> %a, <8 x i32> %b
  %ba = select <8 x i1> %cmp, <8 x i32> %b, <8 x i32> %a
  %sub = sub <8 x i32> %ab, %ba
  ret <8 x i32> %sub
}

define <4 x i64> @xvabsd_du_select(<4 x i64> %a, <4 x i64> %b) nounwind {
; CHECK-LABEL: xvabsd_du_select:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvabsd.du $xr0, $xr0, $xr1
; CHECK-NEXT:    ret
  %cmp = icmp uge <4 x i64> %a, %b
  %ab = select <4 x i1> %cmp, <4 x i64> %a, <4 x i64> %b
  %ba = select <4 x i1> %cmp, <4 x i64> %b, <4 x i64> %a
  %sub = sub <4 x i64> %ab, %ba
  ret <4 x i64> %sub
}

declare <32 x i8> @llvm.abs.v32i8(<32 x i8>, i1)

declare <16 x i16> @llvm.abs.v16i16(<16 x i16>, i1)
declare <32 x i16> @llvm.abs.v32i16(<32 x i16>, i1)

declare <8 x i32> @llvm.abs.v8i32(<8 x i32>, i1)
declare <16 x i32> @llvm.abs.v16i32(<16 x i32>, i1)

declare <4 x i64> @llvm.abs.v4i64(<4 x i64>, i1)
declare <8 x i64> @llvm.abs.v8i64(<8 x i64>, i1)

declare <4 x i128> @llvm.abs.v4i128(<4 x i128>, i1)

declare <32 x i8> @llvm.smax.v32i8(<32 x i8>, <32 x i8>)
declare <16 x i16> @llvm.smax.v16i16(<16 x i16>, <16 x i16>)
declare <8 x i32> @llvm.smax.v8i32(<8 x i32>, <8 x i32>)
declare <4 x i64> @llvm.smax.v4i64(<4 x i64>, <4 x i64>)
declare <32 x i8> @llvm.smin.v32i8(<32 x i8>, <32 x i8>)
declare <16 x i16> @llvm.smin.v16i16(<16 x i16>, <16 x i16>)
declare <8 x i32> @llvm.smin.v8i32(<8 x i32>, <8 x i32>)
declare <4 x i64> @llvm.smin.v4i64(<4 x i64>, <4 x i64>)
declare <32 x i8> @llvm.umax.v32i8(<32 x i8>, <32 x i8>)
declare <16 x i16> @llvm.umax.v16i16(<16 x i16>, <16 x i16>)
declare <8 x i32> @llvm.umax.v8i32(<8 x i32>, <8 x i32>)
declare <4 x i64> @llvm.umax.v4i64(<4 x i64>, <4 x i64>)
declare <32 x i8> @llvm.umin.v32i8(<32 x i8>, <32 x i8>)
declare <16 x i16> @llvm.umin.v16i16(<16 x i16>, <16 x i16>)
declare <8 x i32> @llvm.umin.v8i32(<8 x i32>, <8 x i32>)
declare <4 x i64> @llvm.umin.v4i64(<4 x i64>, <4 x i64>)
