; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_80 -mattr=+ptx70 | FileCheck %s
; RUN: %if ptxas-11.0 %{ llc < %s -mtriple=nvptx64 -mcpu=sm_80 -mattr=+ptx70 | %ptxas-verify -arch=sm_80 %}


define <2 x bfloat> @cvt_rn_bf16x2_f32(float %f1, float %f2) {
; CHECK-LABEL: cvt_rn_bf16x2_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rn_bf16x2_f32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [cvt_rn_bf16x2_f32_param_1];
; CHECK-NEXT:    cvt.rn.bf16x2.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call <2 x bfloat> @llvm.nvvm.ff2bf16x2.rn(float %f1, float %f2)
  ret <2 x bfloat> %val
}

define <2 x bfloat> @cvt_rn_relu_bf16x2_f32(float %f1, float %f2) {
; CHECK-LABEL: cvt_rn_relu_bf16x2_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rn_relu_bf16x2_f32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [cvt_rn_relu_bf16x2_f32_param_1];
; CHECK-NEXT:    cvt.rn.relu.bf16x2.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call <2 x bfloat> @llvm.nvvm.ff2bf16x2.rn.relu(float %f1, float %f2)
  ret <2 x bfloat> %val
}

define <2 x bfloat> @cvt_rz_bf16x2_f32(float %f1, float %f2) {
; CHECK-LABEL: cvt_rz_bf16x2_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rz_bf16x2_f32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [cvt_rz_bf16x2_f32_param_1];
; CHECK-NEXT:    cvt.rz.bf16x2.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call <2 x bfloat> @llvm.nvvm.ff2bf16x2.rz(float %f1, float %f2)
  ret <2 x bfloat> %val
}

define <2 x bfloat> @cvt_rz_relu_bf16x2_f32(float %f1, float %f2) {
; CHECK-LABEL: cvt_rz_relu_bf16x2_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rz_relu_bf16x2_f32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [cvt_rz_relu_bf16x2_f32_param_1];
; CHECK-NEXT:    cvt.rz.relu.bf16x2.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call <2 x bfloat> @llvm.nvvm.ff2bf16x2.rz.relu(float %f1, float %f2)
  ret <2 x bfloat> %val
}

declare <2 x bfloat> @llvm.nvvm.ff2bf16x2.rn(float, float)
declare <2 x bfloat> @llvm.nvvm.ff2bf16x2.rn.relu(float, float)
declare <2 x bfloat> @llvm.nvvm.ff2bf16x2.rz(float, float)
declare <2 x bfloat> @llvm.nvvm.ff2bf16x2.rz.relu(float, float)

define <2 x half> @cvt_rn_f16x2_f32(float %f1, float %f2) {
; CHECK-LABEL: cvt_rn_f16x2_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rn_f16x2_f32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [cvt_rn_f16x2_f32_param_1];
; CHECK-NEXT:    cvt.rn.f16x2.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call <2 x half> @llvm.nvvm.ff2f16x2.rn(float %f1, float %f2)
  ret <2 x half> %val
}

define <2 x half> @cvt_rn_relu_f16x2_f32(float %f1, float %f2) {
; CHECK-LABEL: cvt_rn_relu_f16x2_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rn_relu_f16x2_f32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [cvt_rn_relu_f16x2_f32_param_1];
; CHECK-NEXT:    cvt.rn.relu.f16x2.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call <2 x half> @llvm.nvvm.ff2f16x2.rn.relu(float %f1, float %f2)
  ret <2 x half> %val
}

define <2 x half> @cvt_rz_f16x2_f32(float %f1, float %f2) {
; CHECK-LABEL: cvt_rz_f16x2_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rz_f16x2_f32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [cvt_rz_f16x2_f32_param_1];
; CHECK-NEXT:    cvt.rz.f16x2.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call <2 x half> @llvm.nvvm.ff2f16x2.rz(float %f1, float %f2)
  ret <2 x half> %val
}

define <2 x half> @cvt_rz_relu_f16x2_f32(float %f1, float %f2) {
; CHECK-LABEL: cvt_rz_relu_f16x2_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rz_relu_f16x2_f32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [cvt_rz_relu_f16x2_f32_param_1];
; CHECK-NEXT:    cvt.rz.relu.f16x2.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call <2 x half> @llvm.nvvm.ff2f16x2.rz.relu(float %f1, float %f2)
  ret <2 x half> %val
}

declare <2 x half> @llvm.nvvm.ff2f16x2.rn(float, float)
declare <2 x half> @llvm.nvvm.ff2f16x2.rn.relu(float, float)
declare <2 x half> @llvm.nvvm.ff2f16x2.rz(float, float)
declare <2 x half> @llvm.nvvm.ff2f16x2.rz.relu(float, float)

define bfloat @cvt_rn_bf16_f32(float %f1) {
; CHECK-LABEL: cvt_rn_bf16_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<2>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rn_bf16_f32_param_0];
; CHECK-NEXT:    cvt.rn.bf16.f32 %rs1, %r1;
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs1;
; CHECK-NEXT:    ret;
  %val = call bfloat @llvm.nvvm.f2bf16.rn(float %f1)
  ret bfloat %val
}

define bfloat @cvt_rn_relu_bf16_f32(float %f1) {
; CHECK-LABEL: cvt_rn_relu_bf16_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<2>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rn_relu_bf16_f32_param_0];
; CHECK-NEXT:    cvt.rn.relu.bf16.f32 %rs1, %r1;
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs1;
; CHECK-NEXT:    ret;
  %val = call bfloat @llvm.nvvm.f2bf16.rn.relu(float %f1)
  ret bfloat %val
}

define bfloat @cvt_rz_bf16_f32(float %f1) {
; CHECK-LABEL: cvt_rz_bf16_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<2>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rz_bf16_f32_param_0];
; CHECK-NEXT:    cvt.rz.bf16.f32 %rs1, %r1;
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs1;
; CHECK-NEXT:    ret;
  %val = call bfloat @llvm.nvvm.f2bf16.rz(float %f1)
  ret bfloat %val
}

define bfloat @cvt_rz_relu_bf16_f32(float %f1) {
; CHECK-LABEL: cvt_rz_relu_bf16_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<2>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rz_relu_bf16_f32_param_0];
; CHECK-NEXT:    cvt.rz.relu.bf16.f32 %rs1, %r1;
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs1;
; CHECK-NEXT:    ret;
  %val = call bfloat @llvm.nvvm.f2bf16.rz.relu(float %f1)
  ret bfloat %val
}

declare bfloat @llvm.nvvm.f2bf16.rn(float)
declare bfloat @llvm.nvvm.f2bf16.rn.relu(float)
declare bfloat @llvm.nvvm.f2bf16.rz(float)
declare bfloat @llvm.nvvm.f2bf16.rz.relu(float)

define i32 @cvt_rna_tf32_f32(float %f1) {
; CHECK-LABEL: cvt_rna_tf32_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [cvt_rna_tf32_f32_param_0];
; CHECK-NEXT:    cvt.rna.tf32.f32 %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %val = call i32 @llvm.nvvm.f2tf32.rna(float %f1)
  ret i32 %val
}

declare i32 @llvm.nvvm.f2tf32.rna(float)


define <2 x bfloat> @fold_ff2bf16x2(float %lo, float %hi) {
; CHECK-LABEL: fold_ff2bf16x2(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [fold_ff2bf16x2_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [fold_ff2bf16x2_param_1];
; CHECK-NEXT:    cvt.rn.bf16x2.f32 %r3, %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %loh = fptrunc float %lo to bfloat
  %hih = fptrunc float %hi to bfloat
  %v0 = insertelement <2 x bfloat> poison, bfloat %loh, i64 0
  %v1 = insertelement <2 x bfloat> %v0, bfloat %hih, i64 1
  ret <2 x bfloat> %v1
}

define <2 x half> @fold_ff2f16x2(float %lo, float %hi) {
; CHECK-LABEL: fold_ff2f16x2(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [fold_ff2f16x2_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [fold_ff2f16x2_param_1];
; CHECK-NEXT:    cvt.rn.f16x2.f32 %r3, %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %loh = fptrunc float %lo to half
  %hih = fptrunc float %hi to half
  %v0 = insertelement <2 x half> poison, half %loh, i64 0
  %v1 = insertelement <2 x half> %v0, half %hih, i64 1
  ret <2 x half> %v1
}
