; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mattr=+mve.fp -o - | FileCheck %s

target triple = "thumbv8.1m.main-none-none-eabi"

; Expected to not transform
define arm_aapcs_vfpcc <2 x half> @complex_mul_v2f16(<2 x half> %a, <2 x half> %b) {
; CHECK-LABEL: complex_mul_v2f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovx.f16 s2, s4
; CHECK-NEXT:    vmovx.f16 s8, s0
; CHECK-NEXT:    vmul.f16 s6, s2, s0
; CHECK-NEXT:    vfma.f16 s6, s4, s8
; CHECK-NEXT:    vmul.f16 s8, s8, s2
; CHECK-NEXT:    vfnms.f16 s8, s4, s0
; CHECK-NEXT:    vins.f16 s8, s6
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    bx lr
entry:
  %a.real   = shufflevector <2 x half> %a, <2 x half> poison, <1 x i32> <i32 0>
  %a.imag = shufflevector <2 x half> %a, <2 x half> poison, <1 x i32> <i32 1>
  %b.real = shufflevector <2 x half> %b, <2 x half> poison, <1 x i32> <i32 0>
  %b.imag = shufflevector <2 x half> %b, <2 x half> poison, <1 x i32> <i32 1>
  %0 = fmul fast <1 x half> %b.imag, %a.real
  %1 = fmul fast <1 x half> %b.real, %a.imag
  %2 = fadd fast <1 x half> %1, %0
  %3 = fmul fast <1 x half> %b.real, %a.real
  %4 = fmul fast <1 x half> %a.imag, %b.imag
  %5 = fsub fast <1 x half> %3, %4
  %interleaved.vec = shufflevector <1 x half> %5, <1 x half> %2, <2 x i32> <i32 0, i32 1>
  ret <2 x half> %interleaved.vec
}

; Expected to not transform
define arm_aapcs_vfpcc <4 x half> @complex_mul_v4f16(<4 x half> %a, <4 x half> %b) {
; CHECK-LABEL: complex_mul_v4f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vmovx.f16 s8, s0
; CHECK-NEXT:    vmovx.f16 s2, s1
; CHECK-NEXT:    vins.f16 s8, s2
; CHECK-NEXT:    vmovx.f16 s12, s4
; CHECK-NEXT:    vmovx.f16 s2, s5
; CHECK-NEXT:    vins.f16 s0, s1
; CHECK-NEXT:    vins.f16 s12, s2
; CHECK-NEXT:    vins.f16 s4, s5
; CHECK-NEXT:    vmul.f16 q4, q3, q0
; CHECK-NEXT:    vfma.f16 q4, q1, q2
; CHECK-NEXT:    vmul.f16 q2, q2, q3
; CHECK-NEXT:    vneg.f16 q2, q2
; CHECK-NEXT:    vfma.f16 q2, q1, q0
; CHECK-NEXT:    vmovx.f16 s0, s16
; CHECK-NEXT:    vmovx.f16 s9, s8
; CHECK-NEXT:    vins.f16 s8, s16
; CHECK-NEXT:    vins.f16 s9, s0
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %a.real   = shufflevector <4 x half> %a, <4 x half> poison, <2 x i32> <i32 0, i32 2>
  %a.imag = shufflevector <4 x half> %a, <4 x half> poison, <2 x i32> <i32 1, i32 3>
  %b.real = shufflevector <4 x half> %b, <4 x half> poison, <2 x i32> <i32 0, i32 2>
  %b.imag = shufflevector <4 x half> %b, <4 x half> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul fast <2 x half> %b.imag, %a.real
  %1 = fmul fast <2 x half> %b.real, %a.imag
  %2 = fadd fast <2 x half> %1, %0
  %3 = fmul fast <2 x half> %b.real, %a.real
  %4 = fmul fast <2 x half> %a.imag, %b.imag
  %5 = fsub fast <2 x half> %3, %4
  %interleaved.vec = shufflevector <2 x half> %5, <2 x half> %2, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x half> %interleaved.vec
}

; Expected to transform
define arm_aapcs_vfpcc <8 x half> @complex_mul_v8f16(<8 x half> %a, <8 x half> %b) {
; CHECK-LABEL: complex_mul_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vcmul.f16 q2, q0, q1, #0
; CHECK-NEXT:    vcmla.f16 q2, q0, q1, #90
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    bx lr
entry:
  %a.real   = shufflevector <8 x half> %a, <8 x half> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %a.imag = shufflevector <8 x half> %a, <8 x half> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %b.real = shufflevector <8 x half> %b, <8 x half> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %b.imag = shufflevector <8 x half> %b, <8 x half> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %0 = fmul fast <4 x half> %b.imag, %a.real
  %1 = fmul fast <4 x half> %b.real, %a.imag
  %2 = fadd fast <4 x half> %1, %0
  %3 = fmul fast <4 x half> %b.real, %a.real
  %4 = fmul fast <4 x half> %a.imag, %b.imag
  %5 = fsub fast <4 x half> %3, %4
  %interleaved.vec = shufflevector <4 x half> %5, <4 x half> %2, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  ret <8 x half> %interleaved.vec
}

; Expected to transform
define arm_aapcs_vfpcc <16 x half> @complex_mul_v16f16(<16 x half> %a, <16 x half> %b) {
; CHECK-LABEL: complex_mul_v16f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vcmul.f16 q4, q0, q2, #0
; CHECK-NEXT:    vcmla.f16 q4, q0, q2, #90
; CHECK-NEXT:    vcmul.f16 q2, q1, q3, #0
; CHECK-NEXT:    vcmla.f16 q2, q1, q3, #90
; CHECK-NEXT:    vmov q0, q4
; CHECK-NEXT:    vmov q1, q2
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %a.real   = shufflevector <16 x half> %a, <16 x half> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %a.imag = shufflevector <16 x half> %a, <16 x half> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %b.real = shufflevector <16 x half> %b, <16 x half> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %b.imag = shufflevector <16 x half> %b, <16 x half> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %0 = fmul fast <8 x half> %b.imag, %a.real
  %1 = fmul fast <8 x half> %b.real, %a.imag
  %2 = fadd fast <8 x half> %1, %0
  %3 = fmul fast <8 x half> %b.real, %a.real
  %4 = fmul fast <8 x half> %a.imag, %b.imag
  %5 = fsub fast <8 x half> %3, %4
  %interleaved.vec = shufflevector <8 x half> %5, <8 x half> %2, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  ret <16 x half> %interleaved.vec
}

; Expected to transform
define arm_aapcs_vfpcc <32 x half> @complex_mul_v32f16(<32 x half> %a, <32 x half> %b) {
; CHECK-LABEL: complex_mul_v32f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    add r0, sp, #48
; CHECK-NEXT:    vmov q4, q0
; CHECK-NEXT:    vldrw.u32 q5, [r0]
; CHECK-NEXT:    add r0, sp, #64
; CHECK-NEXT:    vcmul.f16 q0, q0, q5, #0
; CHECK-NEXT:    vcmla.f16 q0, q4, q5, #90
; CHECK-NEXT:    vldrw.u32 q5, [r0]
; CHECK-NEXT:    add r0, sp, #80
; CHECK-NEXT:    vcmul.f16 q4, q1, q5, #0
; CHECK-NEXT:    vcmla.f16 q4, q1, q5, #90
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    add r0, sp, #96
; CHECK-NEXT:    vcmul.f16 q5, q2, q1, #0
; CHECK-NEXT:    vcmla.f16 q5, q2, q1, #90
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vmov q2, q5
; CHECK-NEXT:    vcmul.f16 q6, q3, q1, #0
; CHECK-NEXT:    vcmla.f16 q6, q3, q1, #90
; CHECK-NEXT:    vmov q1, q4
; CHECK-NEXT:    vmov q3, q6
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %a.real   = shufflevector <32 x half> %a, <32 x half> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %a.imag = shufflevector <32 x half> %a, <32 x half> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %b.real = shufflevector <32 x half> %b, <32 x half> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %b.imag = shufflevector <32 x half> %b, <32 x half> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %0 = fmul fast <16 x half> %b.imag, %a.real
  %1 = fmul fast <16 x half> %b.real, %a.imag
  %2 = fadd fast <16 x half> %1, %0
  %3 = fmul fast <16 x half> %b.real, %a.real
  %4 = fmul fast <16 x half> %a.imag, %b.imag
  %5 = fsub fast <16 x half> %3, %4
  %interleaved.vec = shufflevector <16 x half> %5, <16 x half> %2, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
  ret <32 x half> %interleaved.vec
}
