; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes='default<O2>' -S | FileCheck %s
target datalayout = "E-p:32:32"

define ptr @f(ptr %buffer, i32 %n, ptr swifterror %errorslot) {
; CHECK-LABEL: @f(
; CHECK-NEXT:  coro.return:
; CHECK-NEXT:    store i32 [[N:%.*]], ptr [[BUFFER:%.*]], align 4
; CHECK-NEXT:    tail call void @print(i32 [[N]])
; CHECK-NEXT:    store ptr null, ptr [[ERRORSLOT:%.*]], align 4
; CHECK-NEXT:    tail call void @maybeThrow(ptr nonnull swifterror [[ERRORSLOT]])
; CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[ERRORSLOT]], align 4
; CHECK-NEXT:    tail call void @logError(ptr [[TMP0]])
; CHECK-NEXT:    store ptr [[TMP0]], ptr [[ERRORSLOT]], align 4
; CHECK-NEXT:    ret ptr @f.resume.0
;
entry:
  %id = call token @llvm.coro.id.retcon(i32 8, i32 4, ptr %buffer, ptr @f_prototype, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br label %loop

loop:
  %n.val = phi i32 [ %n, %entry ], [ %inc, %resume ]
  call void @print(i32 %n.val)
  call void @maybeThrow(ptr swifterror %errorslot)
  %errorload1 = load ptr, ptr %errorslot
  call void @logError(ptr %errorload1)
  %suspend_result = call { i1, ptr } (...) @llvm.coro.suspend.retcon.i1p0p0i8()
  %unwind0 = extractvalue { i1, ptr } %suspend_result, 0
  br i1 %unwind0, label %cleanup, label %resume

resume:
  %inc = add i32 %n.val, 1
  br label %loop

cleanup:
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token none)
  unreachable
}

;   TODO: figure out a way to eliminate this


define ptr @g(ptr %buffer, i32 %n) {
; CHECK-LABEL: @g(
; CHECK-NEXT:  coro.return:
; CHECK-NEXT:    [[TMP0:%.*]] = alloca swifterror ptr, align 4
; CHECK-NEXT:    store i32 [[N:%.*]], ptr [[BUFFER:%.*]], align 4
; CHECK-NEXT:    tail call void @print(i32 [[N]])
; CHECK-NEXT:    store ptr null, ptr [[TMP0]], align 4
; CHECK-NEXT:    call void @maybeThrow(ptr nonnull swifterror [[TMP0]])
; CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 4
; CHECK-NEXT:    [[DOTSPILL_ADDR:%.*]] = getelementptr inbounds nuw i8, ptr [[BUFFER]], i32 4
; CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTSPILL_ADDR]], align 4
; CHECK-NEXT:    call void @logError(ptr [[TMP1]])
; CHECK-NEXT:    ret ptr @g.resume.0
;
entry:
  %errorslot = alloca swifterror ptr, align 4
  store ptr null, ptr %errorslot
  %id = call token @llvm.coro.id.retcon(i32 8, i32 4, ptr %buffer, ptr @g_prototype, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  br label %loop

loop:
  %n.val = phi i32 [ %n, %entry ], [ %inc, %resume ]
  call void @print(i32 %n.val)
  call void @maybeThrow(ptr swifterror %errorslot)
  %errorload1 = load ptr, ptr %errorslot
  call void @logError(ptr %errorload1)
  %unwind0 = call i1 (...) @llvm.coro.suspend.retcon.i1()
  br i1 %unwind0, label %cleanup, label %resume

resume:
  %inc = add i32 %n.val, 1
  br label %loop

cleanup:
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token none)
  unreachable
}



declare token @llvm.coro.id.retcon(i32, i32, ptr, ptr, ptr, ptr)
declare ptr @llvm.coro.begin(token, ptr)
declare { i1, ptr } @llvm.coro.suspend.retcon.i1p0p0i8(...)
declare i1 @llvm.coro.suspend.retcon.i1(...)
declare i1 @llvm.coro.end(ptr, i1, token)
declare ptr @llvm.coro.prepare.retcon(ptr)

declare ptr @f_prototype(ptr, i1 zeroext, ptr swifterror)
declare ptr @g_prototype(ptr, i1 zeroext)

declare noalias ptr @allocate(i32 %size)
declare void @deallocate(ptr %ptr)

declare void @print(i32)
declare void @maybeThrow(ptr swifterror)
declare void @logError(ptr)
