; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=sparc | FileCheck %s -check-prefix=SPARC
; RUN: llc < %s -mtriple=sparc -mattr=popc | FileCheck %s -check-prefix=SPARC-POPC
; RUN: llc < %s -mtriple=sparc -mattr=vis3 | FileCheck %s -check-prefix=SPARC-VIS3
; RUN: llc < %s -mtriple=sparcv9 | FileCheck %s -check-prefix=SPARC64
; RUN: llc < %s -mtriple=sparcv9 -mattr=popc | FileCheck %s -check-prefix=SPARC64-POPC
; RUN: llc < %s -mtriple=sparcv9 -mattr=vis3 | FileCheck %s -check-prefix=SPARC64-VIS3

define i32 @i32_nopoison(i32 %x) nounwind {
; SPARC-LABEL: i32_nopoison:
; SPARC:       ! %bb.0:
; SPARC-NEXT:    cmp %o0, 0
; SPARC-NEXT:    be .LBB0_2
; SPARC-NEXT:    nop
; SPARC-NEXT:  ! %bb.1: ! %cond.false
; SPARC-NEXT:    sub %g0, %o0, %o1
; SPARC-NEXT:    and %o0, %o1, %o0
; SPARC-NEXT:    sethi 122669, %o1
; SPARC-NEXT:    or %o1, 305, %o1
; SPARC-NEXT:    smul %o0, %o1, %o0
; SPARC-NEXT:    srl %o0, 27, %o0
; SPARC-NEXT:    sethi %hi(.LCPI0_0), %o1
; SPARC-NEXT:    add %o1, %lo(.LCPI0_0), %o1
; SPARC-NEXT:    retl
; SPARC-NEXT:    ldub [%o1+%o0], %o0
; SPARC-NEXT:  .LBB0_2:
; SPARC-NEXT:    retl
; SPARC-NEXT:    mov 32, %o0
;
; SPARC-POPC-LABEL: i32_nopoison:
; SPARC-POPC:       ! %bb.0:
; SPARC-POPC-NEXT:    cmp %o0, 0
; SPARC-POPC-NEXT:    be .LBB0_2
; SPARC-POPC-NEXT:    nop
; SPARC-POPC-NEXT:  ! %bb.1: ! %cond.false
; SPARC-POPC-NEXT:    sub %g0, %o0, %o1
; SPARC-POPC-NEXT:    and %o0, %o1, %o0
; SPARC-POPC-NEXT:    sethi 122669, %o1
; SPARC-POPC-NEXT:    or %o1, 305, %o1
; SPARC-POPC-NEXT:    smul %o0, %o1, %o0
; SPARC-POPC-NEXT:    srl %o0, 27, %o0
; SPARC-POPC-NEXT:    sethi %hi(.LCPI0_0), %o1
; SPARC-POPC-NEXT:    add %o1, %lo(.LCPI0_0), %o1
; SPARC-POPC-NEXT:    retl
; SPARC-POPC-NEXT:    ldub [%o1+%o0], %o0
; SPARC-POPC-NEXT:  .LBB0_2:
; SPARC-POPC-NEXT:    retl
; SPARC-POPC-NEXT:    mov 32, %o0
;
; SPARC-VIS3-LABEL: i32_nopoison:
; SPARC-VIS3:       ! %bb.0:
; SPARC-VIS3-NEXT:    add %o0, -1, %o1
; SPARC-VIS3-NEXT:    andn %o1, %o0, %o0
; SPARC-VIS3-NEXT:    srl %o0, 0, %o0
; SPARC-VIS3-NEXT:    lzcnt %o0, %o0
; SPARC-VIS3-NEXT:    add %o0, -32, %o0
; SPARC-VIS3-NEXT:    mov 32, %o1
; SPARC-VIS3-NEXT:    retl
; SPARC-VIS3-NEXT:    sub %o1, %o0, %o0
;
; SPARC64-LABEL: i32_nopoison:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    cmp %o0, 0
; SPARC64-NEXT:    be %icc, .LBB0_2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:  ! %bb.1: ! %cond.false
; SPARC64-NEXT:    sub %g0, %o0, %o1
; SPARC64-NEXT:    and %o0, %o1, %o0
; SPARC64-NEXT:    sethi 122669, %o1
; SPARC64-NEXT:    or %o1, 305, %o1
; SPARC64-NEXT:    mulx %o0, %o1, %o0
; SPARC64-NEXT:    srl %o0, 27, %o0
; SPARC64-NEXT:    srl %o0, 0, %o0
; SPARC64-NEXT:    sethi %h44(.LCPI0_0), %o1
; SPARC64-NEXT:    add %o1, %m44(.LCPI0_0), %o1
; SPARC64-NEXT:    sllx %o1, 12, %o1
; SPARC64-NEXT:    add %o1, %l44(.LCPI0_0), %o1
; SPARC64-NEXT:    retl
; SPARC64-NEXT:    ldub [%o1+%o0], %o0
; SPARC64-NEXT:  .LBB0_2:
; SPARC64-NEXT:    retl
; SPARC64-NEXT:    mov 32, %o0
;
; SPARC64-POPC-LABEL: i32_nopoison:
; SPARC64-POPC:       ! %bb.0:
; SPARC64-POPC-NEXT:    add %o0, -1, %o1
; SPARC64-POPC-NEXT:    andn %o1, %o0, %o0
; SPARC64-POPC-NEXT:    srl %o0, 0, %o0
; SPARC64-POPC-NEXT:    retl
; SPARC64-POPC-NEXT:    popc %o0, %o0
;
; SPARC64-VIS3-LABEL: i32_nopoison:
; SPARC64-VIS3:       ! %bb.0:
; SPARC64-VIS3-NEXT:    sethi 0, %o1
; SPARC64-VIS3-NEXT:    or %o1, 0, %o2
; SPARC64-VIS3-NEXT:    or %o1, 1, %o1
; SPARC64-VIS3-NEXT:    sllx %o1, 32, %o1
; SPARC64-VIS3-NEXT:    or %o1, %o2, %o1
; SPARC64-VIS3-NEXT:    or %o0, %o1, %o0
; SPARC64-VIS3-NEXT:    add %o0, -1, %o1
; SPARC64-VIS3-NEXT:    andn %o1, %o0, %o0
; SPARC64-VIS3-NEXT:    lzcnt %o0, %o0
; SPARC64-VIS3-NEXT:    mov 64, %o1
; SPARC64-VIS3-NEXT:    retl
; SPARC64-VIS3-NEXT:    sub %o1, %o0, %o0
  %ret = call i32 @llvm.cttz.i32(i32 %x, i1 false)
  ret i32 %ret
}

define i32 @i32_poison(i32 %x) nounwind {
; SPARC-LABEL: i32_poison:
; SPARC:       ! %bb.0:
; SPARC-NEXT:    sub %g0, %o0, %o1
; SPARC-NEXT:    and %o0, %o1, %o0
; SPARC-NEXT:    sethi 122669, %o1
; SPARC-NEXT:    or %o1, 305, %o1
; SPARC-NEXT:    smul %o0, %o1, %o0
; SPARC-NEXT:    srl %o0, 27, %o0
; SPARC-NEXT:    sethi %hi(.LCPI1_0), %o1
; SPARC-NEXT:    add %o1, %lo(.LCPI1_0), %o1
; SPARC-NEXT:    retl
; SPARC-NEXT:    ldub [%o1+%o0], %o0
;
; SPARC-POPC-LABEL: i32_poison:
; SPARC-POPC:       ! %bb.0:
; SPARC-POPC-NEXT:    sub %g0, %o0, %o1
; SPARC-POPC-NEXT:    and %o0, %o1, %o0
; SPARC-POPC-NEXT:    sethi 122669, %o1
; SPARC-POPC-NEXT:    or %o1, 305, %o1
; SPARC-POPC-NEXT:    smul %o0, %o1, %o0
; SPARC-POPC-NEXT:    srl %o0, 27, %o0
; SPARC-POPC-NEXT:    sethi %hi(.LCPI1_0), %o1
; SPARC-POPC-NEXT:    add %o1, %lo(.LCPI1_0), %o1
; SPARC-POPC-NEXT:    retl
; SPARC-POPC-NEXT:    ldub [%o1+%o0], %o0
;
; SPARC-VIS3-LABEL: i32_poison:
; SPARC-VIS3:       ! %bb.0:
; SPARC-VIS3-NEXT:    add %o0, -1, %o1
; SPARC-VIS3-NEXT:    andn %o1, %o0, %o0
; SPARC-VIS3-NEXT:    srl %o0, 0, %o0
; SPARC-VIS3-NEXT:    lzcnt %o0, %o0
; SPARC-VIS3-NEXT:    add %o0, -32, %o0
; SPARC-VIS3-NEXT:    mov 32, %o1
; SPARC-VIS3-NEXT:    retl
; SPARC-VIS3-NEXT:    sub %o1, %o0, %o0
;
; SPARC64-LABEL: i32_poison:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    sub %g0, %o0, %o1
; SPARC64-NEXT:    and %o0, %o1, %o0
; SPARC64-NEXT:    sethi 122669, %o1
; SPARC64-NEXT:    or %o1, 305, %o1
; SPARC64-NEXT:    mulx %o0, %o1, %o0
; SPARC64-NEXT:    srl %o0, 27, %o0
; SPARC64-NEXT:    srl %o0, 0, %o0
; SPARC64-NEXT:    sethi %h44(.LCPI1_0), %o1
; SPARC64-NEXT:    add %o1, %m44(.LCPI1_0), %o1
; SPARC64-NEXT:    sllx %o1, 12, %o1
; SPARC64-NEXT:    add %o1, %l44(.LCPI1_0), %o1
; SPARC64-NEXT:    retl
; SPARC64-NEXT:    ldub [%o1+%o0], %o0
;
; SPARC64-POPC-LABEL: i32_poison:
; SPARC64-POPC:       ! %bb.0:
; SPARC64-POPC-NEXT:    add %o0, -1, %o1
; SPARC64-POPC-NEXT:    andn %o1, %o0, %o0
; SPARC64-POPC-NEXT:    srl %o0, 0, %o0
; SPARC64-POPC-NEXT:    retl
; SPARC64-POPC-NEXT:    popc %o0, %o0
;
; SPARC64-VIS3-LABEL: i32_poison:
; SPARC64-VIS3:       ! %bb.0:
; SPARC64-VIS3-NEXT:    add %o0, -1, %o1
; SPARC64-VIS3-NEXT:    andn %o1, %o0, %o0
; SPARC64-VIS3-NEXT:    lzcnt %o0, %o0
; SPARC64-VIS3-NEXT:    mov 64, %o1
; SPARC64-VIS3-NEXT:    retl
; SPARC64-VIS3-NEXT:    sub %o1, %o0, %o0
  %ret = call i32 @llvm.cttz.i32(i32 %x, i1 true)
  ret i32 %ret
}

define i64 @i64_nopoison(i64 %x) nounwind {
; SPARC-LABEL: i64_nopoison:
; SPARC:       ! %bb.0:
; SPARC-NEXT:    or %o1, %o0, %o2
; SPARC-NEXT:    cmp %o2, 0
; SPARC-NEXT:    be .LBB2_3
; SPARC-NEXT:    nop
; SPARC-NEXT:  ! %bb.1: ! %cond.false
; SPARC-NEXT:    sethi 122669, %o2
; SPARC-NEXT:    or %o2, 305, %o2
; SPARC-NEXT:    sethi %hi(.LCPI2_0), %o3
; SPARC-NEXT:    cmp %o1, 0
; SPARC-NEXT:    bne .LBB2_4
; SPARC-NEXT:    add %o3, %lo(.LCPI2_0), %o3
; SPARC-NEXT:  ! %bb.2: ! %cond.false
; SPARC-NEXT:    sub %g0, %o0, %o1
; SPARC-NEXT:    and %o0, %o1, %o0
; SPARC-NEXT:    smul %o0, %o2, %o0
; SPARC-NEXT:    srl %o0, 27, %o0
; SPARC-NEXT:    ldub [%o3+%o0], %o0
; SPARC-NEXT:    add %o0, 32, %o1
; SPARC-NEXT:    retl
; SPARC-NEXT:    mov %g0, %o0
; SPARC-NEXT:  .LBB2_3:
; SPARC-NEXT:    mov %g0, %o0
; SPARC-NEXT:    retl
; SPARC-NEXT:    mov 64, %o1
; SPARC-NEXT:  .LBB2_4:
; SPARC-NEXT:    sub %g0, %o1, %o0
; SPARC-NEXT:    and %o1, %o0, %o0
; SPARC-NEXT:    smul %o0, %o2, %o0
; SPARC-NEXT:    srl %o0, 27, %o0
; SPARC-NEXT:    ldub [%o3+%o0], %o1
; SPARC-NEXT:    retl
; SPARC-NEXT:    mov %g0, %o0
;
; SPARC-POPC-LABEL: i64_nopoison:
; SPARC-POPC:       ! %bb.0:
; SPARC-POPC-NEXT:    or %o1, %o0, %o2
; SPARC-POPC-NEXT:    cmp %o2, 0
; SPARC-POPC-NEXT:    be .LBB2_3
; SPARC-POPC-NEXT:    nop
; SPARC-POPC-NEXT:  ! %bb.1: ! %cond.false
; SPARC-POPC-NEXT:    sethi 122669, %o2
; SPARC-POPC-NEXT:    or %o2, 305, %o2
; SPARC-POPC-NEXT:    sethi %hi(.LCPI2_0), %o3
; SPARC-POPC-NEXT:    cmp %o1, 0
; SPARC-POPC-NEXT:    bne .LBB2_4
; SPARC-POPC-NEXT:    add %o3, %lo(.LCPI2_0), %o3
; SPARC-POPC-NEXT:  ! %bb.2: ! %cond.false
; SPARC-POPC-NEXT:    sub %g0, %o0, %o1
; SPARC-POPC-NEXT:    and %o0, %o1, %o0
; SPARC-POPC-NEXT:    smul %o0, %o2, %o0
; SPARC-POPC-NEXT:    srl %o0, 27, %o0
; SPARC-POPC-NEXT:    ldub [%o3+%o0], %o0
; SPARC-POPC-NEXT:    add %o0, 32, %o1
; SPARC-POPC-NEXT:    retl
; SPARC-POPC-NEXT:    mov %g0, %o0
; SPARC-POPC-NEXT:  .LBB2_3:
; SPARC-POPC-NEXT:    mov %g0, %o0
; SPARC-POPC-NEXT:    retl
; SPARC-POPC-NEXT:    mov 64, %o1
; SPARC-POPC-NEXT:  .LBB2_4:
; SPARC-POPC-NEXT:    sub %g0, %o1, %o0
; SPARC-POPC-NEXT:    and %o1, %o0, %o0
; SPARC-POPC-NEXT:    smul %o0, %o2, %o0
; SPARC-POPC-NEXT:    srl %o0, 27, %o0
; SPARC-POPC-NEXT:    ldub [%o3+%o0], %o1
; SPARC-POPC-NEXT:    retl
; SPARC-POPC-NEXT:    mov %g0, %o0
;
; SPARC-VIS3-LABEL: i64_nopoison:
; SPARC-VIS3:       ! %bb.0:
; SPARC-VIS3-NEXT:    add %o0, -1, %o2
; SPARC-VIS3-NEXT:    andn %o2, %o0, %o0
; SPARC-VIS3-NEXT:    srl %o0, 0, %o0
; SPARC-VIS3-NEXT:    lzcnt %o0, %o0
; SPARC-VIS3-NEXT:    add %o0, -32, %o0
; SPARC-VIS3-NEXT:    mov 64, %o2
; SPARC-VIS3-NEXT:    sub %o2, %o0, %o2
; SPARC-VIS3-NEXT:    add %o1, -1, %o0
; SPARC-VIS3-NEXT:    andn %o0, %o1, %o0
; SPARC-VIS3-NEXT:    srl %o0, 0, %o0
; SPARC-VIS3-NEXT:    lzcnt %o0, %o0
; SPARC-VIS3-NEXT:    add %o0, -32, %o0
; SPARC-VIS3-NEXT:    mov 32, %o3
; SPARC-VIS3-NEXT:    sub %o3, %o0, %o0
; SPARC-VIS3-NEXT:    cmp %o1, 0
; SPARC-VIS3-NEXT:    movne %icc, %o0, %o2
; SPARC-VIS3-NEXT:    mov %g0, %o0
; SPARC-VIS3-NEXT:    retl
; SPARC-VIS3-NEXT:    mov %o2, %o1
;
; SPARC64-LABEL: i64_nopoison:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    brz %o0, .LBB2_2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:  ! %bb.1: ! %cond.false
; SPARC64-NEXT:    sub %g0, %o0, %o1
; SPARC64-NEXT:    and %o0, %o1, %o0
; SPARC64-NEXT:    sethi 3362647, %o1
; SPARC64-NEXT:    or %o1, 447, %o1
; SPARC64-NEXT:    sethi 34344, %o2
; SPARC64-NEXT:    or %o2, 914, %o2
; SPARC64-NEXT:    sllx %o2, 32, %o2
; SPARC64-NEXT:    or %o2, %o1, %o1
; SPARC64-NEXT:    mulx %o0, %o1, %o0
; SPARC64-NEXT:    srlx %o0, 58, %o0
; SPARC64-NEXT:    sethi %h44(.LCPI2_0), %o1
; SPARC64-NEXT:    add %o1, %m44(.LCPI2_0), %o1
; SPARC64-NEXT:    sllx %o1, 12, %o1
; SPARC64-NEXT:    add %o1, %l44(.LCPI2_0), %o1
; SPARC64-NEXT:    retl
; SPARC64-NEXT:    ldub [%o1+%o0], %o0
; SPARC64-NEXT:  .LBB2_2:
; SPARC64-NEXT:    retl
; SPARC64-NEXT:    mov 64, %o0
;
; SPARC64-POPC-LABEL: i64_nopoison:
; SPARC64-POPC:       ! %bb.0:
; SPARC64-POPC-NEXT:    add %o0, -1, %o1
; SPARC64-POPC-NEXT:    andn %o1, %o0, %o0
; SPARC64-POPC-NEXT:    retl
; SPARC64-POPC-NEXT:    popc %o0, %o0
;
; SPARC64-VIS3-LABEL: i64_nopoison:
; SPARC64-VIS3:       ! %bb.0:
; SPARC64-VIS3-NEXT:    add %o0, -1, %o1
; SPARC64-VIS3-NEXT:    andn %o1, %o0, %o0
; SPARC64-VIS3-NEXT:    lzcnt %o0, %o0
; SPARC64-VIS3-NEXT:    mov 64, %o1
; SPARC64-VIS3-NEXT:    retl
; SPARC64-VIS3-NEXT:    sub %o1, %o0, %o0
  %ret = call i64 @llvm.cttz.i64(i64 %x, i1 false)
  ret i64 %ret
}

define i64 @i64_poison(i64 %x) nounwind {
; SPARC-LABEL: i64_poison:
; SPARC:       ! %bb.0:
; SPARC-NEXT:    sethi 122669, %o2
; SPARC-NEXT:    or %o2, 305, %o2
; SPARC-NEXT:    sethi %hi(.LCPI3_0), %o3
; SPARC-NEXT:    cmp %o1, 0
; SPARC-NEXT:    bne .LBB3_2
; SPARC-NEXT:    add %o3, %lo(.LCPI3_0), %o3
; SPARC-NEXT:  ! %bb.1:
; SPARC-NEXT:    sub %g0, %o0, %o1
; SPARC-NEXT:    and %o0, %o1, %o0
; SPARC-NEXT:    smul %o0, %o2, %o0
; SPARC-NEXT:    srl %o0, 27, %o0
; SPARC-NEXT:    ldub [%o3+%o0], %o0
; SPARC-NEXT:    add %o0, 32, %o1
; SPARC-NEXT:    retl
; SPARC-NEXT:    mov %g0, %o0
; SPARC-NEXT:  .LBB3_2:
; SPARC-NEXT:    sub %g0, %o1, %o0
; SPARC-NEXT:    and %o1, %o0, %o0
; SPARC-NEXT:    smul %o0, %o2, %o0
; SPARC-NEXT:    srl %o0, 27, %o0
; SPARC-NEXT:    ldub [%o3+%o0], %o1
; SPARC-NEXT:    retl
; SPARC-NEXT:    mov %g0, %o0
;
; SPARC-POPC-LABEL: i64_poison:
; SPARC-POPC:       ! %bb.0:
; SPARC-POPC-NEXT:    sethi 122669, %o2
; SPARC-POPC-NEXT:    or %o2, 305, %o2
; SPARC-POPC-NEXT:    sethi %hi(.LCPI3_0), %o3
; SPARC-POPC-NEXT:    cmp %o1, 0
; SPARC-POPC-NEXT:    bne .LBB3_2
; SPARC-POPC-NEXT:    add %o3, %lo(.LCPI3_0), %o3
; SPARC-POPC-NEXT:  ! %bb.1:
; SPARC-POPC-NEXT:    sub %g0, %o0, %o1
; SPARC-POPC-NEXT:    and %o0, %o1, %o0
; SPARC-POPC-NEXT:    smul %o0, %o2, %o0
; SPARC-POPC-NEXT:    srl %o0, 27, %o0
; SPARC-POPC-NEXT:    ldub [%o3+%o0], %o0
; SPARC-POPC-NEXT:    add %o0, 32, %o1
; SPARC-POPC-NEXT:    retl
; SPARC-POPC-NEXT:    mov %g0, %o0
; SPARC-POPC-NEXT:  .LBB3_2:
; SPARC-POPC-NEXT:    sub %g0, %o1, %o0
; SPARC-POPC-NEXT:    and %o1, %o0, %o0
; SPARC-POPC-NEXT:    smul %o0, %o2, %o0
; SPARC-POPC-NEXT:    srl %o0, 27, %o0
; SPARC-POPC-NEXT:    ldub [%o3+%o0], %o1
; SPARC-POPC-NEXT:    retl
; SPARC-POPC-NEXT:    mov %g0, %o0
;
; SPARC-VIS3-LABEL: i64_poison:
; SPARC-VIS3:       ! %bb.0:
; SPARC-VIS3-NEXT:    add %o0, -1, %o2
; SPARC-VIS3-NEXT:    andn %o2, %o0, %o0
; SPARC-VIS3-NEXT:    srl %o0, 0, %o0
; SPARC-VIS3-NEXT:    lzcnt %o0, %o0
; SPARC-VIS3-NEXT:    add %o0, -32, %o0
; SPARC-VIS3-NEXT:    mov 64, %o2
; SPARC-VIS3-NEXT:    sub %o2, %o0, %o2
; SPARC-VIS3-NEXT:    add %o1, -1, %o0
; SPARC-VIS3-NEXT:    andn %o0, %o1, %o0
; SPARC-VIS3-NEXT:    srl %o0, 0, %o0
; SPARC-VIS3-NEXT:    lzcnt %o0, %o0
; SPARC-VIS3-NEXT:    add %o0, -32, %o0
; SPARC-VIS3-NEXT:    mov 32, %o3
; SPARC-VIS3-NEXT:    sub %o3, %o0, %o0
; SPARC-VIS3-NEXT:    cmp %o1, 0
; SPARC-VIS3-NEXT:    movne %icc, %o0, %o2
; SPARC-VIS3-NEXT:    mov %g0, %o0
; SPARC-VIS3-NEXT:    retl
; SPARC-VIS3-NEXT:    mov %o2, %o1
;
; SPARC64-LABEL: i64_poison:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    sub %g0, %o0, %o1
; SPARC64-NEXT:    and %o0, %o1, %o0
; SPARC64-NEXT:    sethi 3362647, %o1
; SPARC64-NEXT:    or %o1, 447, %o1
; SPARC64-NEXT:    sethi 34344, %o2
; SPARC64-NEXT:    or %o2, 914, %o2
; SPARC64-NEXT:    sllx %o2, 32, %o2
; SPARC64-NEXT:    or %o2, %o1, %o1
; SPARC64-NEXT:    mulx %o0, %o1, %o0
; SPARC64-NEXT:    srlx %o0, 58, %o0
; SPARC64-NEXT:    sethi %h44(.LCPI3_0), %o1
; SPARC64-NEXT:    add %o1, %m44(.LCPI3_0), %o1
; SPARC64-NEXT:    sllx %o1, 12, %o1
; SPARC64-NEXT:    add %o1, %l44(.LCPI3_0), %o1
; SPARC64-NEXT:    retl
; SPARC64-NEXT:    ldub [%o1+%o0], %o0
;
; SPARC64-POPC-LABEL: i64_poison:
; SPARC64-POPC:       ! %bb.0:
; SPARC64-POPC-NEXT:    add %o0, -1, %o1
; SPARC64-POPC-NEXT:    andn %o1, %o0, %o0
; SPARC64-POPC-NEXT:    retl
; SPARC64-POPC-NEXT:    popc %o0, %o0
;
; SPARC64-VIS3-LABEL: i64_poison:
; SPARC64-VIS3:       ! %bb.0:
; SPARC64-VIS3-NEXT:    add %o0, -1, %o1
; SPARC64-VIS3-NEXT:    andn %o1, %o0, %o0
; SPARC64-VIS3-NEXT:    lzcnt %o0, %o0
; SPARC64-VIS3-NEXT:    mov 64, %o1
; SPARC64-VIS3-NEXT:    retl
; SPARC64-VIS3-NEXT:    sub %o1, %o0, %o0
  %ret = call i64 @llvm.cttz.i64(i64 %x, i1 true)
  ret i64 %ret
}
