; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test use of LOAD LOGICAL INDEXED ADDRESS word instructions.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z17 | FileCheck %s

; LLXAF with base and index.
define dso_local ptr @f0(ptr %ptr, i32 %idx) {
; CHECK-LABEL: f0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    llxaf %r2, 0(%r3,%r2)
; CHECK-NEXT:    br %r14
  %idxprom = zext i32 %idx to i64
  %arrayidx = getelementptr inbounds i32, ptr %ptr, i64 %idxprom
  ret ptr %arrayidx
}

; LLXAF with base and index (implied extension).
define dso_local ptr @f1(ptr %ptr, i32 zeroext %idx) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    llxaf %r2, 0(%r3,%r2)
; CHECK-NEXT:    br %r14
  %idxprom = zext i32 %idx to i64
  %arrayidx = getelementptr inbounds i32, ptr %ptr, i64 %idxprom
  ret ptr %arrayidx
}

; LLXAF with base and index and max displacement.
define dso_local ptr @f2(ptr %ptr, i32 %idx) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    llxaf %r2, 524287(%r3,%r2)
; CHECK-NEXT:    br %r14
  %idxoff = add i32 %idx, 524287
  %idxprom = zext i32 %idxoff to i64
  %arrayidx = getelementptr inbounds i32, ptr %ptr, i64 %idxprom
  ret ptr %arrayidx
}

; LLXAF with base and index and min displacement.
define dso_local ptr @f3(ptr %ptr, i32 %idx) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    llxaf %r2, -524288(%r3,%r2)
; CHECK-NEXT:    br %r14
  %idxoff = add i32 %idx, -524288
  %idxprom = zext i32 %idxoff to i64
  %arrayidx = getelementptr inbounds i32, ptr %ptr, i64 %idxprom
  ret ptr %arrayidx
}

; LLXAF with base and index and max displacement overflow.
define dso_local ptr @f4(ptr %ptr, i32 %idx) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    afi %r3, 524288
; CHECK-NEXT:    llxaf %r2, 0(%r3,%r2)
; CHECK-NEXT:    br %r14
  %idxoff = add i32 %idx, 524288
  %idxprom = zext i32 %idxoff to i64
  %arrayidx = getelementptr inbounds i32, ptr %ptr, i64 %idxprom
  ret ptr %arrayidx
}

; LLXAF with base and index and min displacement overflow.
define dso_local ptr @f5(ptr %ptr, i32 %idx) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    afi %r3, -524289
; CHECK-NEXT:    llxaf %r2, 0(%r3,%r2)
; CHECK-NEXT:    br %r14
  %idxoff = add i32 %idx, -524289
  %idxprom = zext i32 %idxoff to i64
  %arrayidx = getelementptr inbounds i32, ptr %ptr, i64 %idxprom
  ret ptr %arrayidx
}

; DO NOT USE: LLXAF with index.
define dso_local i64 @f6(i32 %idx) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $r2l killed $r2l def $r2d
; CHECK-NEXT:    risbgn %r2, %r2, 30, 189, 2
; CHECK-NEXT:    br %r14
  %idxprom = zext i32 %idx to i64
  %idxshift = shl i64 %idxprom, 2
  ret i64 %idxshift
}

; LLXAF with index and displacement.
define dso_local i64 @f7(i32 %idx) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    llxaf %r2, 1(%r2,0)
; CHECK-NEXT:    br %r14
  %idxoff = add i32 %idx, 1
  %idxprom = zext i32 %idxoff to i64
  %idxshift = shl i64 %idxprom, 2
  ret i64 %idxshift
}

