/*
 * Copyright (C) 2020 Rerrah
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#pragma once

#include <vector>
#include <string>
#include <memory>
#include "module.hpp"

namespace command_utils
{
inline Step& getStep(std::weak_ptr<Module> mod, int song, int track, int order, int step)
{
	return mod.lock()->getSong(song).getTrack(track)
			.getPatternFromOrderNumber(order).getStep(step);
}

inline Step& getStep(Song& song, int track, int order, int step)
{
	return song.getTrack(track).getPatternFromOrderNumber(order).getStep(step);
}

inline Pattern& getPattern(std::weak_ptr<Module> mod, int song, int track, int order)
{
	return mod.lock()->getSong(song).getTrack(track).getPatternFromOrderNumber(order);
}

inline Pattern& getPattern(Song& song, int track, int order)
{
	return song.getTrack(track).getPatternFromOrderNumber(order);
}

size_t calculateColumnSize(int beginTrack, int beginColumn, int endTrack, int endColumn);

std::vector<std::vector<std::string>> getPreviousCells(Song& song, size_t w, size_t h, int beginTrack,
													   int beginColumn, int beginOrder, int beginStep);

void restorePattern(Song& song, const std::vector<std::vector<std::string>>& cells, int beginTrack,
					int beginColumn, int beginOrder, int beginStep);
}
