#!/bin/sh

autogen/readme-version

for vec in avx2 sse42
do
  for bits in 32 64
  do
    mkdir -p int$bits/$vec
    ( echo amd64 $vec; echo x86 $vec ) > int$bits/$vec/architectures
    autogen/sort $bits $vec > int$bits/$vec/sort.c
  done
done

for vec in neon
do
  for bits in 32 64
  do
    mkdir -p int$bits/$vec
    echo arm64 > int$bits/$vec/architectures
    autogen/sort $bits $vec > int$bits/$vec/sort.c
  done
done

autogen/useint

autogen/test > command/djbsort-test.c
autogen/speed > command/djbsort-speed.c
autogen/html
autogen/man

(cd sortbench; ./benchgen.py)
