/*
 * gbp-arduino-board-option.h
 *
 * Copyright 2025 Nokse <nokse@posteo.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <libide-foundry.h>

G_BEGIN_DECLS

#define GBP_TYPE_ARDUINO_BOARD_OPTION (gbp_arduino_board_option_get_type ())
G_DECLARE_FINAL_TYPE (GbpArduinoBoardOption, gbp_arduino_board_option, GBP, ARDUINO_BOARD_OPTION, GObject)

GbpArduinoBoardOption *gbp_arduino_board_option_new (const char *option,
                                                     const char *option_label);

void gbp_arduino_board_option_add_value (GbpArduinoBoardOption *self,
                                         const char *value,
                                         const char *value_label);

GListStore *gbp_arduino_board_option_get_values (GbpArduinoBoardOption *self);

const char *gbp_arduino_board_option_get_option (GbpArduinoBoardOption *self);

const char *gbp_arduino_board_option_get_option_label (GbpArduinoBoardOption *self);

G_END_DECLS
