// Code generated by smithy-go-codegen DO NOT EDIT.

package kendra

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kendra/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Provides a list of groups that are mapped to users before a given ordering or
// timestamp identifier.
//
// ListGroupsOlderThanOrderingId is currently not supported in the Amazon Web
// Services GovCloud (US-West) region.
func (c *Client) ListGroupsOlderThanOrderingId(ctx context.Context, params *ListGroupsOlderThanOrderingIdInput, optFns ...func(*Options)) (*ListGroupsOlderThanOrderingIdOutput, error) {
	if params == nil {
		params = &ListGroupsOlderThanOrderingIdInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListGroupsOlderThanOrderingId", params, optFns, c.addOperationListGroupsOlderThanOrderingIdMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListGroupsOlderThanOrderingIdOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListGroupsOlderThanOrderingIdInput struct {

	// The identifier of the index for getting a list of groups mapped to users before
	// a given ordering or timestamp identifier.
	//
	// This member is required.
	IndexId *string

	// The timestamp identifier used for the latest PUT or DELETE action for mapping
	// users to their groups.
	//
	// This member is required.
	OrderingId *int64

	// The identifier of the data source for getting a list of groups mapped to users
	// before a given ordering timestamp identifier.
	DataSourceId *string

	//  The maximum number of returned groups that are mapped to users before a given
	// ordering or timestamp identifier.
	MaxResults *int32

	//  If the previous response was incomplete (because there is more data to
	// retrieve), Amazon Kendra returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of groups that are mapped to
	// users before a given ordering or timestamp identifier.
	NextToken *string

	noSmithyDocumentSerde
}

type ListGroupsOlderThanOrderingIdOutput struct {

	//  Summary information for list of groups that are mapped to users before a given
	// ordering or timestamp identifier.
	GroupsSummaries []types.GroupSummary

	//  If the response is truncated, Amazon Kendra returns this token that you can
	// use in the subsequent request to retrieve the next set of groups that are mapped
	// to users before a given ordering or timestamp identifier.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListGroupsOlderThanOrderingIdMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListGroupsOlderThanOrderingId{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListGroupsOlderThanOrderingId{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListGroupsOlderThanOrderingId"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListGroupsOlderThanOrderingIdValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListGroupsOlderThanOrderingId(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListGroupsOlderThanOrderingIdPaginatorOptions is the paginator options for
// ListGroupsOlderThanOrderingId
type ListGroupsOlderThanOrderingIdPaginatorOptions struct {
	//  The maximum number of returned groups that are mapped to users before a given
	// ordering or timestamp identifier.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListGroupsOlderThanOrderingIdPaginator is a paginator for
// ListGroupsOlderThanOrderingId
type ListGroupsOlderThanOrderingIdPaginator struct {
	options   ListGroupsOlderThanOrderingIdPaginatorOptions
	client    ListGroupsOlderThanOrderingIdAPIClient
	params    *ListGroupsOlderThanOrderingIdInput
	nextToken *string
	firstPage bool
}

// NewListGroupsOlderThanOrderingIdPaginator returns a new
// ListGroupsOlderThanOrderingIdPaginator
func NewListGroupsOlderThanOrderingIdPaginator(client ListGroupsOlderThanOrderingIdAPIClient, params *ListGroupsOlderThanOrderingIdInput, optFns ...func(*ListGroupsOlderThanOrderingIdPaginatorOptions)) *ListGroupsOlderThanOrderingIdPaginator {
	if params == nil {
		params = &ListGroupsOlderThanOrderingIdInput{}
	}

	options := ListGroupsOlderThanOrderingIdPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListGroupsOlderThanOrderingIdPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListGroupsOlderThanOrderingIdPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListGroupsOlderThanOrderingId page.
func (p *ListGroupsOlderThanOrderingIdPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListGroupsOlderThanOrderingIdOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListGroupsOlderThanOrderingId(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListGroupsOlderThanOrderingIdAPIClient is a client that implements the
// ListGroupsOlderThanOrderingId operation.
type ListGroupsOlderThanOrderingIdAPIClient interface {
	ListGroupsOlderThanOrderingId(context.Context, *ListGroupsOlderThanOrderingIdInput, ...func(*Options)) (*ListGroupsOlderThanOrderingIdOutput, error)
}

var _ ListGroupsOlderThanOrderingIdAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListGroupsOlderThanOrderingId(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListGroupsOlderThanOrderingId",
	}
}
