//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// TestJobStreamsServer is a fake server for instances of the armautomation.TestJobStreamsClient type.
type TestJobStreamsServer struct {
	// Get is the fake for method TestJobStreamsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, automationAccountName string, runbookName string, jobStreamID string, options *armautomation.TestJobStreamsClientGetOptions) (resp azfake.Responder[armautomation.TestJobStreamsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByTestJobPager is the fake for method TestJobStreamsClient.NewListByTestJobPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTestJobPager func(resourceGroupName string, automationAccountName string, runbookName string, options *armautomation.TestJobStreamsClientListByTestJobOptions) (resp azfake.PagerResponder[armautomation.TestJobStreamsClientListByTestJobResponse])
}

// NewTestJobStreamsServerTransport creates a new instance of TestJobStreamsServerTransport with the provided implementation.
// The returned TestJobStreamsServerTransport instance is connected to an instance of armautomation.TestJobStreamsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTestJobStreamsServerTransport(srv *TestJobStreamsServer) *TestJobStreamsServerTransport {
	return &TestJobStreamsServerTransport{
		srv:                   srv,
		newListByTestJobPager: newTracker[azfake.PagerResponder[armautomation.TestJobStreamsClientListByTestJobResponse]](),
	}
}

// TestJobStreamsServerTransport connects instances of armautomation.TestJobStreamsClient to instances of TestJobStreamsServer.
// Don't use this type directly, use NewTestJobStreamsServerTransport instead.
type TestJobStreamsServerTransport struct {
	srv                   *TestJobStreamsServer
	newListByTestJobPager *tracker[azfake.PagerResponder[armautomation.TestJobStreamsClientListByTestJobResponse]]
}

// Do implements the policy.Transporter interface for TestJobStreamsServerTransport.
func (t *TestJobStreamsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TestJobStreamsClient.Get":
		resp, err = t.dispatchGet(req)
	case "TestJobStreamsClient.NewListByTestJobPager":
		resp, err = t.dispatchNewListByTestJobPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TestJobStreamsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runbooks/(?P<runbookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/draft/testJob/streams/(?P<jobStreamId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	runbookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("runbookName")])
	if err != nil {
		return nil, err
	}
	jobStreamIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobStreamId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), resourceGroupNameParam, automationAccountNameParam, runbookNameParam, jobStreamIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JobStream, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TestJobStreamsServerTransport) dispatchNewListByTestJobPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByTestJobPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTestJobPager not implemented")}
	}
	newListByTestJobPager := t.newListByTestJobPager.get(req)
	if newListByTestJobPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runbooks/(?P<runbookName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/draft/testJob/streams`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
		if err != nil {
			return nil, err
		}
		runbookNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("runbookName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armautomation.TestJobStreamsClientListByTestJobOptions
		if filterParam != nil {
			options = &armautomation.TestJobStreamsClientListByTestJobOptions{
				Filter: filterParam,
			}
		}
		resp := t.srv.NewListByTestJobPager(resourceGroupNameParam, automationAccountNameParam, runbookNameParam, options)
		newListByTestJobPager = &resp
		t.newListByTestJobPager.add(req, newListByTestJobPager)
		server.PagerResponderInjectNextLinks(newListByTestJobPager, req, func(page *armautomation.TestJobStreamsClientListByTestJobResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTestJobPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByTestJobPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTestJobPager) {
		t.newListByTestJobPager.remove(req)
	}
	return resp, nil
}
