//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/desktopvirtualization/armdesktopvirtualization/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
	"strconv"
)

// ScalingPlanPooledSchedulesServer is a fake server for instances of the armdesktopvirtualization.ScalingPlanPooledSchedulesClient type.
type ScalingPlanPooledSchedulesServer struct {
	// Create is the fake for method ScalingPlanPooledSchedulesClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, scalingPlanSchedule armdesktopvirtualization.ScalingPlanPooledSchedule, options *armdesktopvirtualization.ScalingPlanPooledSchedulesClientCreateOptions) (resp azfake.Responder[armdesktopvirtualization.ScalingPlanPooledSchedulesClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ScalingPlanPooledSchedulesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, options *armdesktopvirtualization.ScalingPlanPooledSchedulesClientDeleteOptions) (resp azfake.Responder[armdesktopvirtualization.ScalingPlanPooledSchedulesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ScalingPlanPooledSchedulesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, options *armdesktopvirtualization.ScalingPlanPooledSchedulesClientGetOptions) (resp azfake.Responder[armdesktopvirtualization.ScalingPlanPooledSchedulesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ScalingPlanPooledSchedulesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, scalingPlanName string, options *armdesktopvirtualization.ScalingPlanPooledSchedulesClientListOptions) (resp azfake.PagerResponder[armdesktopvirtualization.ScalingPlanPooledSchedulesClientListResponse])

	// Update is the fake for method ScalingPlanPooledSchedulesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, options *armdesktopvirtualization.ScalingPlanPooledSchedulesClientUpdateOptions) (resp azfake.Responder[armdesktopvirtualization.ScalingPlanPooledSchedulesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewScalingPlanPooledSchedulesServerTransport creates a new instance of ScalingPlanPooledSchedulesServerTransport with the provided implementation.
// The returned ScalingPlanPooledSchedulesServerTransport instance is connected to an instance of armdesktopvirtualization.ScalingPlanPooledSchedulesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewScalingPlanPooledSchedulesServerTransport(srv *ScalingPlanPooledSchedulesServer) *ScalingPlanPooledSchedulesServerTransport {
	return &ScalingPlanPooledSchedulesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armdesktopvirtualization.ScalingPlanPooledSchedulesClientListResponse]](),
	}
}

// ScalingPlanPooledSchedulesServerTransport connects instances of armdesktopvirtualization.ScalingPlanPooledSchedulesClient to instances of ScalingPlanPooledSchedulesServer.
// Don't use this type directly, use NewScalingPlanPooledSchedulesServerTransport instead.
type ScalingPlanPooledSchedulesServerTransport struct {
	srv          *ScalingPlanPooledSchedulesServer
	newListPager *tracker[azfake.PagerResponder[armdesktopvirtualization.ScalingPlanPooledSchedulesClientListResponse]]
}

// Do implements the policy.Transporter interface for ScalingPlanPooledSchedulesServerTransport.
func (s *ScalingPlanPooledSchedulesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ScalingPlanPooledSchedulesClient.Create":
		resp, err = s.dispatchCreate(req)
	case "ScalingPlanPooledSchedulesClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "ScalingPlanPooledSchedulesClient.Get":
		resp, err = s.dispatchGet(req)
	case "ScalingPlanPooledSchedulesClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "ScalingPlanPooledSchedulesClient.Update":
		resp, err = s.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ScalingPlanPooledSchedulesServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if s.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/scalingPlans/(?P<scalingPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/pooledSchedules/(?P<scalingPlanScheduleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdesktopvirtualization.ScalingPlanPooledSchedule](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	scalingPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanName")])
	if err != nil {
		return nil, err
	}
	scalingPlanScheduleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanScheduleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Create(req.Context(), resourceGroupNameParam, scalingPlanNameParam, scalingPlanScheduleNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScalingPlanPooledSchedule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScalingPlanPooledSchedulesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/scalingPlans/(?P<scalingPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/pooledSchedules/(?P<scalingPlanScheduleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	scalingPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanName")])
	if err != nil {
		return nil, err
	}
	scalingPlanScheduleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanScheduleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, scalingPlanNameParam, scalingPlanScheduleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScalingPlanPooledSchedulesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/scalingPlans/(?P<scalingPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/pooledSchedules/(?P<scalingPlanScheduleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	scalingPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanName")])
	if err != nil {
		return nil, err
	}
	scalingPlanScheduleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanScheduleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, scalingPlanNameParam, scalingPlanScheduleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScalingPlanPooledSchedule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ScalingPlanPooledSchedulesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/scalingPlans/(?P<scalingPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/pooledSchedules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		scalingPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanName")])
		if err != nil {
			return nil, err
		}
		pageSizeUnescaped, err := url.QueryUnescape(qp.Get("pageSize"))
		if err != nil {
			return nil, err
		}
		pageSizeParam, err := parseOptional(pageSizeUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		isDescendingUnescaped, err := url.QueryUnescape(qp.Get("isDescending"))
		if err != nil {
			return nil, err
		}
		isDescendingParam, err := parseOptional(isDescendingUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		initialSkipUnescaped, err := url.QueryUnescape(qp.Get("initialSkip"))
		if err != nil {
			return nil, err
		}
		initialSkipParam, err := parseOptional(initialSkipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdesktopvirtualization.ScalingPlanPooledSchedulesClientListOptions
		if pageSizeParam != nil || isDescendingParam != nil || initialSkipParam != nil {
			options = &armdesktopvirtualization.ScalingPlanPooledSchedulesClientListOptions{
				PageSize:     pageSizeParam,
				IsDescending: isDescendingParam,
				InitialSkip:  initialSkipParam,
			}
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, scalingPlanNameParam, options)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armdesktopvirtualization.ScalingPlanPooledSchedulesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *ScalingPlanPooledSchedulesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DesktopVirtualization/scalingPlans/(?P<scalingPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/pooledSchedules/(?P<scalingPlanScheduleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdesktopvirtualization.ScalingPlanPooledSchedulePatch](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	scalingPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanName")])
	if err != nil {
		return nil, err
	}
	scalingPlanScheduleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("scalingPlanScheduleName")])
	if err != nil {
		return nil, err
	}
	var options *armdesktopvirtualization.ScalingPlanPooledSchedulesClientUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armdesktopvirtualization.ScalingPlanPooledSchedulesClientUpdateOptions{
			ScalingPlanSchedule: &body,
		}
	}
	respr, errRespr := s.srv.Update(req.Context(), resourceGroupNameParam, scalingPlanNameParam, scalingPlanScheduleNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ScalingPlanPooledSchedule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
