//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/maintenance/armmaintenance"
	"net/http"
	"net/url"
	"regexp"
)

// ApplyUpdatesServer is a fake server for instances of the armmaintenance.ApplyUpdatesClient type.
type ApplyUpdatesServer struct {
	// CreateOrUpdate is the fake for method ApplyUpdatesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, providerName string, resourceType string, resourceName string, options *armmaintenance.ApplyUpdatesClientCreateOrUpdateOptions) (resp azfake.Responder[armmaintenance.ApplyUpdatesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateParent is the fake for method ApplyUpdatesClient.CreateOrUpdateParent
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateParent func(ctx context.Context, resourceGroupName string, providerName string, resourceParentType string, resourceParentName string, resourceType string, resourceName string, options *armmaintenance.ApplyUpdatesClientCreateOrUpdateParentOptions) (resp azfake.Responder[armmaintenance.ApplyUpdatesClientCreateOrUpdateParentResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ApplyUpdatesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, providerName string, resourceType string, resourceName string, applyUpdateName string, options *armmaintenance.ApplyUpdatesClientGetOptions) (resp azfake.Responder[armmaintenance.ApplyUpdatesClientGetResponse], errResp azfake.ErrorResponder)

	// GetParent is the fake for method ApplyUpdatesClient.GetParent
	// HTTP status codes to indicate success: http.StatusOK
	GetParent func(ctx context.Context, resourceGroupName string, providerName string, resourceParentType string, resourceParentName string, resourceType string, resourceName string, applyUpdateName string, options *armmaintenance.ApplyUpdatesClientGetParentOptions) (resp azfake.Responder[armmaintenance.ApplyUpdatesClientGetParentResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ApplyUpdatesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armmaintenance.ApplyUpdatesClientListOptions) (resp azfake.PagerResponder[armmaintenance.ApplyUpdatesClientListResponse])
}

// NewApplyUpdatesServerTransport creates a new instance of ApplyUpdatesServerTransport with the provided implementation.
// The returned ApplyUpdatesServerTransport instance is connected to an instance of armmaintenance.ApplyUpdatesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewApplyUpdatesServerTransport(srv *ApplyUpdatesServer) *ApplyUpdatesServerTransport {
	return &ApplyUpdatesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmaintenance.ApplyUpdatesClientListResponse]](),
	}
}

// ApplyUpdatesServerTransport connects instances of armmaintenance.ApplyUpdatesClient to instances of ApplyUpdatesServer.
// Don't use this type directly, use NewApplyUpdatesServerTransport instead.
type ApplyUpdatesServerTransport struct {
	srv          *ApplyUpdatesServer
	newListPager *tracker[azfake.PagerResponder[armmaintenance.ApplyUpdatesClientListResponse]]
}

// Do implements the policy.Transporter interface for ApplyUpdatesServerTransport.
func (a *ApplyUpdatesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ApplyUpdatesClient.CreateOrUpdate":
		resp, err = a.dispatchCreateOrUpdate(req)
	case "ApplyUpdatesClient.CreateOrUpdateParent":
		resp, err = a.dispatchCreateOrUpdateParent(req)
	case "ApplyUpdatesClient.Get":
		resp, err = a.dispatchGet(req)
	case "ApplyUpdatesClient.GetParent":
		resp, err = a.dispatchGetParent(req)
	case "ApplyUpdatesClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *ApplyUpdatesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<providerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Maintenance/applyUpdates/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	providerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerName")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, providerNameParam, resourceTypeParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ApplyUpdate, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplyUpdatesServerTransport) dispatchCreateOrUpdateParent(req *http.Request) (*http.Response, error) {
	if a.srv.CreateOrUpdateParent == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateParent not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<providerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceParentType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceParentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Maintenance/applyUpdates/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	providerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerName")])
	if err != nil {
		return nil, err
	}
	resourceParentTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceParentType")])
	if err != nil {
		return nil, err
	}
	resourceParentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceParentName")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CreateOrUpdateParent(req.Context(), resourceGroupNameParam, providerNameParam, resourceParentTypeParam, resourceParentNameParam, resourceTypeParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ApplyUpdate, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplyUpdatesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<providerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Maintenance/applyUpdates/(?P<applyUpdateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	providerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerName")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	applyUpdateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applyUpdateName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, providerNameParam, resourceTypeParam, resourceNameParam, applyUpdateNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ApplyUpdate, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplyUpdatesServerTransport) dispatchGetParent(req *http.Request) (*http.Response, error) {
	if a.srv.GetParent == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetParent not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<providerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceParentType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceParentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Maintenance/applyUpdates/(?P<applyUpdateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 8 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	providerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerName")])
	if err != nil {
		return nil, err
	}
	resourceParentTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceParentType")])
	if err != nil {
		return nil, err
	}
	resourceParentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceParentName")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	applyUpdateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applyUpdateName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetParent(req.Context(), resourceGroupNameParam, providerNameParam, resourceParentTypeParam, resourceParentNameParam, resourceTypeParam, resourceNameParam, applyUpdateNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ApplyUpdate, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ApplyUpdatesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Maintenance/applyUpdates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := a.srv.NewListPager(nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}
