//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/visualstudio/armvisualstudio"
	"net/http"
	"net/url"
	"regexp"
)

// ExtensionsServer is a fake server for instances of the armvisualstudio.ExtensionsClient type.
type ExtensionsServer struct {
	// Create is the fake for method ExtensionsClient.Create
	// HTTP status codes to indicate success: http.StatusOK
	Create func(ctx context.Context, resourceGroupName string, accountResourceName string, extensionResourceName string, body armvisualstudio.ExtensionResourceRequest, options *armvisualstudio.ExtensionsClientCreateOptions) (resp azfake.Responder[armvisualstudio.ExtensionsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ExtensionsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK
	Delete func(ctx context.Context, resourceGroupName string, accountResourceName string, extensionResourceName string, options *armvisualstudio.ExtensionsClientDeleteOptions) (resp azfake.Responder[armvisualstudio.ExtensionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ExtensionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNotFound
	Get func(ctx context.Context, resourceGroupName string, accountResourceName string, extensionResourceName string, options *armvisualstudio.ExtensionsClientGetOptions) (resp azfake.Responder[armvisualstudio.ExtensionsClientGetResponse], errResp azfake.ErrorResponder)

	// ListByAccount is the fake for method ExtensionsClient.ListByAccount
	// HTTP status codes to indicate success: http.StatusOK
	ListByAccount func(ctx context.Context, resourceGroupName string, accountResourceName string, options *armvisualstudio.ExtensionsClientListByAccountOptions) (resp azfake.Responder[armvisualstudio.ExtensionsClientListByAccountResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method ExtensionsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, accountResourceName string, extensionResourceName string, body armvisualstudio.ExtensionResourceRequest, options *armvisualstudio.ExtensionsClientUpdateOptions) (resp azfake.Responder[armvisualstudio.ExtensionsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewExtensionsServerTransport creates a new instance of ExtensionsServerTransport with the provided implementation.
// The returned ExtensionsServerTransport instance is connected to an instance of armvisualstudio.ExtensionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewExtensionsServerTransport(srv *ExtensionsServer) *ExtensionsServerTransport {
	return &ExtensionsServerTransport{srv: srv}
}

// ExtensionsServerTransport connects instances of armvisualstudio.ExtensionsClient to instances of ExtensionsServer.
// Don't use this type directly, use NewExtensionsServerTransport instead.
type ExtensionsServerTransport struct {
	srv *ExtensionsServer
}

// Do implements the policy.Transporter interface for ExtensionsServerTransport.
func (e *ExtensionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ExtensionsClient.Create":
		resp, err = e.dispatchCreate(req)
	case "ExtensionsClient.Delete":
		resp, err = e.dispatchDelete(req)
	case "ExtensionsClient.Get":
		resp, err = e.dispatchGet(req)
	case "ExtensionsClient.ListByAccount":
		resp, err = e.dispatchListByAccount(req)
	case "ExtensionsClient.Update":
		resp, err = e.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if e.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.visualstudio/account/(?P<accountResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extension/(?P<extensionResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armvisualstudio.ExtensionResourceRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountResourceName")])
	if err != nil {
		return nil, err
	}
	extensionResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("extensionResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Create(req.Context(), resourceGroupNameParam, accountResourceNameParam, extensionResourceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExtensionResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if e.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.visualstudio/account/(?P<accountResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extension/(?P<extensionResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountResourceName")])
	if err != nil {
		return nil, err
	}
	extensionResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("extensionResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Delete(req.Context(), resourceGroupNameParam, accountResourceNameParam, extensionResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.visualstudio/account/(?P<accountResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extension/(?P<extensionResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountResourceName")])
	if err != nil {
		return nil, err
	}
	extensionResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("extensionResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), resourceGroupNameParam, accountResourceNameParam, extensionResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExtensionResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchListByAccount(req *http.Request) (*http.Response, error) {
	if e.srv.ListByAccount == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByAccount not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.visualstudio/account/(?P<accountResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extension`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.ListByAccount(req.Context(), resourceGroupNameParam, accountResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExtensionResourceListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExtensionsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/microsoft\.visualstudio/account/(?P<accountResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/extension/(?P<extensionResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armvisualstudio.ExtensionResourceRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountResourceName")])
	if err != nil {
		return nil, err
	}
	extensionResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("extensionResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Update(req.Context(), resourceGroupNameParam, accountResourceNameParam, extensionResourceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExtensionResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
