#!/usr/bin/env python3

# Libervia: an XMPP client
# Copyright (C) 2009-2021 Jérôme Poisson (goffi@goffi.org)

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.

# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
from typing import TYPE_CHECKING
from sat_tmp import wokkel

__version__ = "0.9.0.dev0"

if not wokkel.installed:
    wokkel.install()

if TYPE_CHECKING:
    from libervia.backend.core.main import LiberviaBackend
    from libervia.backend.memory.sqla import Storage
    from libervia.backend.tools.config import Settings


class Global:

    def __init__(self):
        self._host: "LiberviaBackend|None" = None

    def set_host(self, host: "LiberviaBackend") -> None:
        """This method set the backend, and must be called once."""
        assert self._host is None
        self._host = host

    @property
    def host(self) -> "LiberviaBackend":
        assert self._host is not None
        return self._host

    @property
    def storage(self) -> "Storage":
        return self.host.memory.storage

    @property
    def config(self) -> "Settings":
        return self.host.memory.config


G = Global()
