% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-distinct.R
\name{distinct.tbl_lazy}
\alias{distinct.tbl_lazy}
\title{Subset distinct/unique rows}
\usage{
\method{distinct}{tbl_lazy}(.data, ..., .keep_all = FALSE)
}
\arguments{
\item{.data}{A lazy data frame backed by a database query.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables, or
functions of variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending
order.}

\item{.keep_all}{If \code{TRUE}, keep all variables in \code{.data}.
If a combination of \code{...} is not distinct, this keeps the
first row of values.}
}
\value{
Another \code{tbl_lazy}. Use \code{\link[dplyr:explain]{dplyr::show_query()}} to see the generated
query, and use \code{\link[=collect.tbl_sql]{collect()}} to execute the query
and return data to R.
}
\description{
This is a method for the dplyr \code{\link[dplyr:distinct]{dplyr::distinct()}} generic. It adds the
\code{DISTINCT} clause to the SQL query.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(x = c(1, 1, 2, 2), y = c(1, 2, 1, 1))
db \%>\% distinct() \%>\% show_query()
db \%>\% distinct(x) \%>\% show_query()
}
