% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagged_na.R
\name{unique_tagged_na}
\alias{unique_tagged_na}
\alias{duplicated_tagged_na}
\alias{order_tagged_na}
\alias{sort_tagged_na}
\title{Unique elements, duplicated, ordering and sorting with tagged NAs}
\usage{
unique_tagged_na(x, fromLast = FALSE)

duplicated_tagged_na(x, fromLast = FALSE)

order_tagged_na(
  x,
  na.last = TRUE,
  decreasing = FALSE,
  method = c("auto", "shell", "radix"),
  na_decreasing = decreasing,
  untagged_na_last = TRUE
)

sort_tagged_na(
  x,
  decreasing = FALSE,
  na.last = TRUE,
  na_decreasing = decreasing,
  untagged_na_last = TRUE
)
}
\arguments{
\item{x}{a vector}

\item{fromLast}{logical indicating if duplication should be
considered from the last}

\item{na.last}{if \code{TRUE}, missing values in the data are put last;
if \code{FALSE}, they are put first}

\item{decreasing}{should the sort order be increasing or decreasing?}

\item{method}{the method to be used, see \code{\link[base:order]{base::order()}}}

\item{na_decreasing}{should the sort order for tagged NAs value be}

\item{untagged_na_last}{should untagged \code{NA}s be sorted after tagged \code{NA}s?
increasing or decreasing?}
}
\description{
These adaptations of \code{\link[base:unique]{base::unique()}}, \code{\link[base:duplicated]{base::duplicated()}},
\code{\link[base:order]{base::order()}} and \code{\link[base:sort]{base::sort()}} treats tagged NAs as distinct
values.
}
\examples{
x <- c(1, 2, tagged_na("a"), 1, tagged_na("z"), 2, tagged_na("a"), NA)
x \%>\% print_tagged_na()

unique(x) \%>\% print_tagged_na()
unique_tagged_na(x) \%>\% print_tagged_na()

duplicated(x)
duplicated_tagged_na(x)

order(x)
order_tagged_na(x)

sort(x, na.last = TRUE) \%>\% print_tagged_na()
sort_tagged_na(x) \%>\% print_tagged_na()
}
