% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hoist.R
\name{hoist}
\alias{hoist}
\title{Hoist values out of list-columns}
\usage{
hoist(
  .data,
  .col,
  ...,
  .remove = TRUE,
  .simplify = TRUE,
  .ptype = NULL,
  .transform = NULL
)
}
\arguments{
\item{.data}{A data frame.}

\item{.col}{<\code{\link[=tidyr_tidy_select]{tidy-select}}> List-column to extract
components from.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Components of \code{.col} to turn
into columns in the form \code{col_name = "pluck_specification"}. You can pluck
by name with a character vector, by position with an integer vector, or
with a combination of the two with a list. See \code{\link[purrr:pluck]{purrr::pluck()}} for
details.

The column names must be unique in a call to \code{hoist()}, although existing
columns with the same name will be overwritten. When plucking with a
single string you can choose to omit the name, i.e. \code{hoist(df, col, "x")}
is short-hand for \code{hoist(df, col, x = "x")}.}

\item{.remove}{If \code{TRUE}, the default, will remove extracted components
from \code{.col}. This ensures that each value lives only in one place. If all
components are removed from \code{.col}, then \code{.col} will be removed from the
result entirely.}

\item{.simplify}{If \code{TRUE}, will attempt to simplify lists of
length-1 vectors to an atomic vector. Can also be a named list containing
\code{TRUE} or \code{FALSE} declaring whether or not to attempt to simplify a
particular column. If a named list is provided, the default for any
unspecified columns is \code{TRUE}.}

\item{.ptype}{Optionally, a named list of prototypes declaring the
desired output type of each component. Alternatively, a single empty
prototype can be supplied, which will be applied to all components. Use
this argument if you want to check that each element has the type you
expect when simplifying.

If a \code{ptype} has been specified, but \code{simplify = FALSE} or simplification
isn't possible, then a \link[vctrs:list_of]{list-of} column will be returned
and each element will have type \code{ptype}.}

\item{.transform}{Optionally, a named list of transformation
functions applied to each component. Alternatively, a single function can
be supplied, which will be applied to all components. Use this argument if
you want to transform or parse individual elements as they are extracted.

When both \code{ptype} and \code{transform} are supplied, the \code{transform} is applied
before the \code{ptype}.}
}
\description{
\code{hoist()} allows you to selectively pull components of a list-column
into their own top-level columns, using the same syntax as \code{\link[purrr:pluck]{purrr::pluck()}}.

Learn more in \code{vignette("rectangle")}.
}
\examples{
df <- tibble(
  character = c("Toothless", "Dory"),
  metadata = list(
    list(
      species = "dragon",
      color = "black",
      films = c(
        "How to Train Your Dragon",
        "How to Train Your Dragon 2",
        "How to Train Your Dragon: The Hidden World"
      )
    ),
    list(
      species = "blue tang",
      color = "blue",
      films = c("Finding Nemo", "Finding Dory")
    )
  )
)
df

# Extract only specified components
df |> hoist(metadata,
  "species",
  first_film = list("films", 1L),
  third_film = list("films", 3L)
)
}
\seealso{
Other rectangling: 
\code{\link{unnest}()},
\code{\link{unnest_longer}()},
\code{\link{unnest_wider}()}
}
\concept{rectangling}
