### New features

* [#11024](https://github.com/rubocop/rubocop/issues/11024): Add `require_always` option to `Style/EndlessMethod`. ([@koic][])
* [#11024](https://github.com/rubocop/rubocop/issues/11024): Add `require_single_line` option to `Style/EndlessMethod`. ([@jtannas][])
* [#9935](https://github.com/rubocop/rubocop/issues/9935): Introduce EnforcedStyleForMultiline "diff_comma". ([@flavorjones][])

### Bug fixes

* [#13867](https://github.com/rubocop/rubocop/issues/13867): Fix an error for plugins when not running RuboCop through Bundler. ([@earlopain][])
* [#13902](https://github.com/rubocop/rubocop/pull/13902): Fix false negative for `Style/RedundantSelfAssignment` when the method receives a block. ([@vlad-pisanov][])
* [#13826](https://github.com/rubocop/rubocop/issues/13826): Fix false positives for regex cops when `Lint/MixedCaseRange` is enabled. ([@earlopain][])
* [#13818](https://github.com/rubocop/rubocop/issues/13818): Fix false positives for `Lint/Void` when using operator method call without argument. ([@koic][])
* [#13896](https://github.com/rubocop/rubocop/pull/13896): Fix a false positive for `Style/TrivialAccessors` with `instance_eval` and numblocks. ([@earlopain][])
* [#13910](https://github.com/rubocop/rubocop/pull/13910): Fix false positives for `Style/EndlessMethod` when using setter method definitions. ([@koic][])
* [#13889](https://github.com/rubocop/rubocop/pull/13889): Fix autocorrection for `Layout/LineLength` with interpolated strings when not on the first line. ([@dvandersluis][])
* [#13900](https://github.com/rubocop/rubocop/issues/13900): Fix infinite loop between `Layout/EmptyLinesAroundAccessModifier` and `Layout/EmptyLinesAroundBlockBody` with `EnforcedStyle: no_empty_lines`. ([@dvandersluis][])
* [#12692](https://github.com/rubocop/rubocop/issues/12692): Fix `Style/AccessorGrouping` with constants. ([@tejasbubane][])
* [#13882](https://github.com/rubocop/rubocop/issues/13882): Fix `Style/RedundantFormat` for annotated template strings with missing hash keys. ([@dvandersluis][])
* [#13880](https://github.com/rubocop/rubocop/issues/13880): Fix `Style/RedundantFormat` when given double-splatted arguments. ([@dvandersluis][])
* [#13907](https://github.com/rubocop/rubocop/pull/13907): Don't offer autocorrect for `Style/StringConcatenation` when numblocks are used. ([@earlopain][])
* [#13876](https://github.com/rubocop/rubocop/issues/13876): Don't consider `require 'pp'` to be redundant for `Lint/RedundantRequireStatement`. ([@earlopain][])
* [#13885](https://github.com/rubocop/rubocop/issues/13885): Update `Style/HashExcept` and `Style/HashSlice` to not register an offense if selecting over the hash value. ([@dvandersluis][])

### Changes

* [#12948](https://github.com/rubocop/rubocop/issues/12948): Add `ForbiddenNames` configuration to `Naming/VariableName` to specify names that are forbidden. ([@dvandersluis][])
* [#13117](https://github.com/rubocop/rubocop/issues/13117): Add partial autocorrect support to `Lint/LiteralAsCondition` cop to check for redundant conditions. ([@zopolis4][])
* [#13892](https://github.com/rubocop/rubocop/pull/13892): Allow merging of configured arrays and non-arrays. ([@sambostock][])
* [#13833](https://github.com/rubocop/rubocop/pull/13833): Add `Reference` to common params. ([@sambostock][])
* [#13890](https://github.com/rubocop/rubocop/pull/13890): Update `Lint/RedundantTypeConversion` to not register an offense when given a constructor with `exception: false`. ([@dvandersluis][])
* [#13729](https://github.com/rubocop/rubocop/pull/13729): Update `Style/RedundantCondition` cop to detect conditional expressions where the true branch is `true` and suggest replacing them with a logical OR. ([@datpmt][])

[@koic]: https://github.com/koic
[@jtannas]: https://github.com/jtannas
[@flavorjones]: https://github.com/flavorjones
[@earlopain]: https://github.com/earlopain
[@vlad-pisanov]: https://github.com/vlad-pisanov
[@dvandersluis]: https://github.com/dvandersluis
[@tejasbubane]: https://github.com/tejasbubane
[@zopolis4]: https://github.com/zopolis4
[@sambostock]: https://github.com/sambostock
[@datpmt]: https://github.com/datpmt
