### Bug fixes

* [#14587](https://github.com/rubocop/rubocop/issues/14587): Fix an error for `Lint/SelfAssignment` when using `[]=` assignment with no arguments. ([@koic][])
* [#14572](https://github.com/rubocop/rubocop/issues/14572): Fix an error for `Style/ArrayIntersect` when `intersection(other).any?` is called without a receiver. ([@koic][])
* [#14599](https://github.com/rubocop/rubocop/pull/14599): Fix a crash when `Style/ConditionalAssignment` is configured with `assign_inside_conditional` and the conditional contains a multi-line regex. ([@martinemde][])
* [#14574](https://github.com/rubocop/rubocop/pull/14574): Fix false positives for `Style/RedundantInterpolation` when using a one-line `=>` pattern matching. ([@koic][])
* [#14602](https://github.com/rubocop/rubocop/issues/14602): Fix false positives for `Style/EndlessMethod` when heredoc is used in method body. ([@koic][])
* [#14594](https://github.com/rubocop/rubocop/issues/14594): Fix false positives for `Style/EndlessMethod` when the endless method would exceed the maximum line length. ([@koic][])
* [#14605](https://github.com/rubocop/rubocop/issues/14605): Fix false positive for `Lint/EmptyInterpolation` when interpolation is inside a `%W` literal. ([@dvandersluis][])
* [#14604](https://github.com/rubocop/rubocop/issues/14604): Fix `Style/RedundantFormat` false positive when a interpolated value is given to a specifier with a width or precision. ([@dvandersluis][])
* [#14607](https://github.com/rubocop/rubocop/pull/14607): Fix `Style/RedundantFormat` handling control characters like `\n`. ([@dvandersluis][])
* [#14577](https://github.com/rubocop/rubocop/pull/14577): Fix an incorrect autocorrect for `Style/Semicolon` when a method call using hash value omission without parentheses is terminated with a semicolon. ([@koic][])
* [#14552](https://github.com/rubocop/rubocop/issues/14552): Fix a false positive for `Security/JSONLoad` when `create_additions` is explicitly specified. ([@earlopain][])

### Changes

* [#14566](https://github.com/rubocop/rubocop/pull/14566): Enhance `Lint::ConstantOverwrittenInRescue` cop to detect offenses within fully qualified constants. ([@viralpraxis][])
* [#14575](https://github.com/rubocop/rubocop/pull/14575): Enhance `Lint/ConstantOverwrittenInRescue` cop to detect offenses within nested constants. ([@viralpraxis][])
* [#14596](https://github.com/rubocop/rubocop/pull/14596): Change `Lint/ConstantOverwrittenInRescue` to detect any constant assignment. ([@viralpraxis][])
* [#14568](https://github.com/rubocop/rubocop/pull/14568): Make `Style/LambdaCall` autocorrection contextual. ([@koic][])

[@koic]: https://github.com/koic
[@martinemde]: https://github.com/martinemde
[@dvandersluis]: https://github.com/dvandersluis
[@earlopain]: https://github.com/earlopain
[@viralpraxis]: https://github.com/viralpraxis
