//
// Copyright Aliaksei Levin (levlam@telegram.org), Arseny Smirnov (arseny30@gmail.com) 2014-2025
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
#pragma once

#include <string>
#include <vector>

namespace tde2e_core {

struct TestVector {
  std::string name;
  std::string secret;
  std::string data;
  std::string extra;
  std::string header;
  std::string encrypted;
  std::string encrypted_header;
};

inline std::vector<TestVector> get_test_vectors() {
  return {
      {"empty_message", "f9fb473b9887e50ea38eef7380c82361432cd4b22c5f9b3700809990d8ed344c", "", "",
       "bd29703cf44551710ca14d091a6c98ee347931b2b8140faaaef2dbb40719df12",
       "d28eb3e3d1328f06dafedabd67a353d5ea6e164d2f34c162a16f8a1164663a03",
       "4060edd7bcacca6dd0f4fe81d6ec63a8859fa9d520598043bc4748919f3fdeda"},
      {"simple_message", "f9fb473b9887e50ea38eef7380c82361432cd4b22c5f9b3700809990d8ed344c",
       "48656c6c6f2c20576f726c6421", "", "bd29703cf44551710ca14d091a6c98ee347931b2b8140faaaef2dbb40719df12",
       "967f5245b03e07ab7be6044174306a4af811e96708ae3ad2ab427aa5495508b1c319ca0353531c0a2921e307f2455856",
       "9e7910949e526b6ad51a59aad8022c826b00f379e28592ed3216aabc6be252e0"},
      {"long_message", "f9fb473b9887e50ea38eef7380c82361432cd4b22c5f9b3700809990d8ed344c",
       "787878787878787878787878787878787878787878787878787878787878787878787878787878787878787878787878787878787878787"
       "878787878787878787878787878787878787878787878787878787878787878787878787878787878787878787878787878787878787878"
       "787878787878787878787878787878787878787878787878787878787878787878787878787878787878787878787878787878787878787"
       "8787878787878787878787878787878787878787878787878787878787878787878",
       "", "bd29703cf44551710ca14d091a6c98ee347931b2b8140faaaef2dbb40719df12",
       "8202a46a19de7111166f6c244127c84dbdc1c3a63ca6526dc699c6cbbc6f8236ee82a0172ed1115cb4a2ba8e27cfa8089822c7e9070ec2f"
       "5c7cee77cc979447c1db9758119ad28a05b2edfc1c98b486985bb60fb6f1fefb4b5f7ecea19d59b8018f865a7be3771c7f6fe6092b34b78"
       "a1bddefc8d07f2f61351a4247c41a58cb068ebe9110245de4fda076f0ff73aede4e9811678424f648b8054b921b53f0612dfbdb7173a86b"
       "ce3eba73955afef435599ae34825d295e8d298d6d3a1fc07084740c0b1c3a24cebedbd26b631cbbd1a352c1a499ba3576a628a74ab14eb1"
       "d180e5af7e9eac4020b889fafc4f7bfb2e24",
       "641620351a1e4d76711385d5cf3b0eed07308c9cafc06ef09ed0c1f57ebb5f42"},
      {"random_message", "f9fb473b9887e50ea38eef7380c82361432cd4b22c5f9b3700809990d8ed344c",
       "fed306c137017ab008c22d1f74bc104e5138d3c19b42fb303c768b083912a1102d06ac1e0f4440e3b32b9144a50e6fc0f190273bd4dec7e"
       "f847bf7d46680bb67",
       "736d616c6c206578747261", "bd29703cf44551710ca14d091a6c98ee347931b2b8140faaaef2dbb40719df12",
       "ee198e4860c888ab18bcecba5083eb539f402be1fbde51e0c49e398145d40ebb7b5a52bdc83d6200e63a70c47cc6a5e6fa7a71f6e24b722"
       "b5f0314b6b52768dbd2e438a582d1cf2a54d4de7ba30e36e68afd8379b63a345483dbcc33380fd07f",
       "f282da8a41f17a5fa7f793c6c134c5bb2b960a2fea43bdc15b58a69cb7dafb43"},
      {"very_long_message", "f9fb473b9887e50ea38eef7380c82361432cd4b22c5f9b3700809990d8ed344c",
       "d16554889d83850ffb42d119e0c69d8b68ee07ff021f0a2cb7beb70d0b1cc62e3d8fe2dff95e674893393b5da015a965108c785d8935a3e"
       "e58e3df9505016020b558687ee535f9bcfa94450ded18ac3e8145879af43e66eeacfee1d9f9c9c78824cf34639af50fb0b93de73aa9362c"
       "f2732e2d8c652111ec1246c8ded3b19e93d154d04cc8a4bd927332136d7627e71e6be2c97dd62235dfd998d1e630588d10beeab791e0919"
       "9bfa8bab3b9e6dbcdfba9f9dd76110f7f6c7fd1fbccc421e7ad093e8fd385e53e3c03f7f0a79296962de1e752eea5f8c5e6325ef406aef5"
       "62d8ef0b9431defeb46fb93ee3c3409af0e3a4f7e63af4efbfb5f4b61a104c1158247877a28f9538d6cf8c5e243ece977cc2a0a0bcf602c"
       "d16df445cb71a4f6a0494a3b6a1149725c169dc40eb10",
       "ebc6b1176ca69b8bb769bcc68add44fbba1c79d2771ef412eccad3ee4f7afe595f8fd2052f8d1d8b8fea209c568eb6a4c6aea6d88c583df"
       "25ed3f38260c2f95c1f0244219d55e658498b34f7e7a527c60723b6806fe28275337b0c9b64c158825a3c14d8cec6a40bbf8c5a5a8009ca"
       "75f2c6f2e7f3ab612ff5d675f2c3b801d4d4e0408b49d8543d8621de0df26a65a49d1fc7a21584d5495a24b2090479870e852766f6de34b"
       "724e5941097d19153f4f4d035ae0c978ec6354ba452cf465581cd4afd7045bfa4c54383796587d19e981da220cd9ca5230161eaf64d8a1b"
       "406a2f8afc7faeb0ec7634c3c14aa63736c955b56c48c61ba58b109775ac252f3837e8bcebdb40f4ca2ce32609619b0063cb421a268f80c"
       "60ffc7c99963f74033d22283a6d2ab3095f65cb49a17e",
       "bd29703cf44551710ca14d091a6c98ee347931b2b8140faaaef2dbb40719df12",
       "c96e7fadcf4e51f5c0dc03aeed33352d7f984c2d49791d173caad17d724b98155ff6b3dc6e082b90063434e9f85941c085dd8573fb4f23d"
       "d0867615249e8e8c567ba74d4e6739919c46afc0a6b19b26c0e37e1810952dcb859b8a2df9ed322da89c4e7821166939809d2561980ff77"
       "d3b797f1ecb1ed78e39614e096c72bed4587ac3229929ae4e164da9b00323410f8b17abed5cc8455656ee73114119e20b529294f8c578f7"
       "f9492327ff40f9f1255abe84f7445c87c8b048e98eac746f6d58fb3261f61eb039e5e88da46c9fc5e35baeb0c1180e9913f49ab7aac5f59"
       "76be1e384071470d80ddbf77c52e781f954d77978697cf555d1586469ce21ccd45f43283eeec3b976d6bd897f436ef9ccacde5da73f298b"
       "d1b99c10e988befeb2988f8f03f96215a746590d35ff0a6a85fa1102d63a00cd71e3cb80753bfe98bf6744f2aec697993dab51cce21f823"
       "656870",
       "97b6b5b2082a66182783c0be6940ca9d63e931195b6cc84dbf9158e9b39834ac"},
      {"message_with_special_chars", "f9fb473b9887e50ea38eef7380c82361432cd4b22c5f9b3700809990d8ed344c",
       "2122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f", "",
       "bd29703cf44551710ca14d091a6c98ee347931b2b8140faaaef2dbb40719df12",
       "b862c41221e3242c07c375dfded48e302aaebed7fbc91bbfe3b7c88345a58d3a13d83cfb87f08250b2d66f4590b5dd2bb2b08fabd4328d1"
       "04f7b4e1bad80931c",
       "7557d10f233e47a56f74a57458b5169e8cce5c4c98e3a3da02f6e49a3db4c2b3"},
      {"message_with_unicode", "f9fb473b9887e50ea38eef7380c82361432cd4b22c5f9b3700809990d8ed344c",
       "48656c6c6f2c20e4b896e7958c21", "", "bd29703cf44551710ca14d091a6c98ee347931b2b8140faaaef2dbb40719df12",
       "cb0d460ca3daf8e3fd5623965b39b5c1de840e92d39f6caf4662b7a7983c53b29fe644bf45acea2644507ac01f0617a2",
       "ebe8636326b11d90f9a670e63086e2fcd02b78c0aa5cacdb4f887e511d1ae4c9"},
  };
}

}  // namespace tde2e_core
