#!/usr/bin/env python3
# DESCRIPTION: Verilator: Verilog Test driver/expect definition
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of either the GNU Lesser General Public License Version 3
# or the Perl Artistic License Version 2.0.
# SPDX-FileCopyrightText: 2024 Wilson Snyder
# SPDX-License-Identifier: LGPL-3.0-only OR Artistic-2.0

import vltest_bootstrap

test.priority(180)
test.scenarios('dist')

test.clean_command = '/bin/rm -rf ../examples/*/build ../examples/*/obj*'

if not os.path.exists(test.root + "/.git"):
    test.skip("Not in a git repository")

examples = sorted(test.glob_some(test.root + "/examples/*"))
for example in examples:
    test.run(cmd=[os.environ["MAKE"], "-C", example])

test.passes()
