/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef PURLEDIT_H
#define PURLEDIT_H

#include "propertywidget.h"

#ifndef PURE_QT
#include <tdefile.h>
class KURLRequester;
#else
#include <klineedit.h>
class TQPushButton;
#endif


namespace PropertyLib{

/**
@short %Property editor with an url editor to choose the location of file or directory.
*/
class PUrlEdit : public PropertyWidget
{
TQ_OBJECT
  
public:
#ifndef PURE_QT
    enum Mode {File = KFile::File,Directory = KFile::Directory};
#else
    enum Mode {File,Directory};
#endif

    PUrlEdit(Mode mode, MultiProperty* property, TQWidget* parent=0, const char* name=0);

    virtual TQVariant value() const;
    virtual void setValue(const TQVariant& value, bool emitChange);
    
private slots:
    void updateProperty(const TQString &val);    
    void select();
private:
#ifndef PURE_QT
    KURLRequester *m_edit;
#else
    KLineEdit *m_edit;
    TQPushButton *m_select;
    TQString m_url;
    Mode m_mode;
#endif
};

}

#endif
