/* ============================================================
 * File  : kameraklient.cpp
 * Author: Tudor Calin <tudor@1xtech.com>
 * Date  : 2004-06-18
 * Description : 
 * 
 * Copyright 2004 by Tudor Calin <tudor@1xtech.com>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

// TQt
#include <tqiconset.h>
#include <tqwidget.h>
// KDE
#include <tdeaboutdata.h>
#include <tdeaction.h>
#include <kdebug.h>
#include <kgenericfactory.h>
#include <tdeinstance.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <tdeshortcut.h>
#include <kstandarddirs.h>
// Local
#include "cameraui.h"
#include "kameraklient.h"

typedef KGenericFactory<Plugin_KameraKlient> Factory;
K_EXPORT_COMPONENT_FACTORY(kipiplugin_kameraklient, Factory("kipiplugin_kameraklient"))

Plugin_KameraKlient::Plugin_KameraKlient(TQObject *parent, const char*, const TQStringList&)
		: KIPI::Plugin(Factory::instance(), parent, "KameraKlient") {
	kdDebug() << "KameraKlient KIPI Plugin loaded" << endl;
}

Plugin_KameraKlient::~Plugin_KameraKlient() {
}

void Plugin_KameraKlient::setup(TQWidget* widget) {
	KIPI::Plugin::setup(widget);
	mKameraKlientAction = new TDEAction(i18n("Digital Camera"),
							"camera-unmounted",
							TDEShortcut(),
							this,
							TQ_SLOT(slotActivate()),
							actionCollection(),
							"kipiplugin_kameraklient");
	addAction(mKameraKlientAction);
}

void Plugin_KameraKlient::slotActivate() {
    KIPIKameraKlientPlugin::CameraUI *mCameraUI = new KIPIKameraKlientPlugin::CameraUI();
    mCameraUI->show(); 
}

KIPI::Category Plugin_KameraKlient::category(TDEAction* action) const {
	if (action==mKameraKlientAction) {
	    return KIPI::IMPORTPLUGIN;
	}

    kdWarning( 51000 ) << "Unrecognized action for plugin category identification" << endl;
    return KIPI::IMPORTPLUGIN; // no warning from compiler, please   
}

#include "kameraklient.moc"

