/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef XMLWORKXMLWORK_H
#define XMLWORKXMLWORK_H

class TQString;
class TQDomDocument;
class TQDomElement;

/** All related functions to manage XML files and trees
  * @author Sbastien Laot
  */
namespace XMLWork
{
	// Manage XML files :
	TQDomDocument* openFile(const TQString &name, const TQString &filePath);
	// Manage XML trees :
	TQDomElement   getElement(const TQDomElement &startElement, const TQString &elementPath);
	TQString       getElementText(const TQDomElement &startElement, const TQString &elementPath, const TQString &defaultTxt = "");
	void          addElement(TQDomDocument &document, TQDomElement &parent, const TQString &name, const TQString &text);
	TQString       innerXml(TQDomElement &element);
	// Not directly related to XML :
	bool          trueOrFalse(const TQString &value, bool defaultValue = true);
	TQString       trueOrFalse(bool value);
}

#endif // XMLWORKXMLWORK_H
