/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-12-21
 * Description : USB Mass Storage camera interface
 *
 * Copyright (C) 2004-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2005-2008 by Gilles Caulier <caulier dot gilles at gmail dot com> 
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef UMSCAMERA_H
#define UMSCAMERA_H

// TQt includes.

#include <tqstringlist.h>

// Local includes.

#include "dkcamera.h"

namespace Digikam
{

class UMSCameraPriv;

class UMSCamera : public DKCamera
{
public:

    UMSCamera(const TQString& title, const TQString& model, const TQString& port, const TQString& path);
    ~UMSCamera();

    bool doConnect();
    void cancel();

    void getAllFolders(const TQString& folder, TQStringList& subFolderList);
    bool getItemsInfoList(const TQString& folder, GPItemInfoList& infoList, bool getImageDimensions=true);
    bool getThumbnail(const TQString& folder, const TQString& itemName, TQImage& thumbnail);
    bool getExif(const TQString& folder, const TQString& itemName, char **edata, int& esize);

    bool setLockItem(const TQString& folder, const TQString& itemName, bool lock);

    bool downloadItem(const TQString& folder, const TQString& itemName, const TQString& saveFile);
    bool deleteItem(const TQString& folder, const TQString& itemName);
    bool uploadItem(const TQString& folder, const TQString& itemName, const TQString& localFile,
                    GPItemInfo& info, bool getImageDimensions=true);

    bool cameraSummary(TQString& summary);
    bool cameraManual(TQString& manual);
    bool cameraAbout(TQString& about);

private:

    void listFolders(const TQString& folder, TQStringList& subFolderList);

private:

    bool m_cancel;
};

}  // namespace Digikam

#endif /* UMSCAMERA_H */
