/***************************************************************************
 *   Copyright (C) 2006 by Peter Penz (peter.penz@gmx.at)                  *
 *   Copyright (C) 2006 by Aaron J. Seigo (<aseigo@kde.org>)               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "urlnavigatorbutton.h"
#include <kurl.h>
#include <tqtooltip.h>
#include <tqcursor.h>
#include <tqfontmetrics.h>
#include <kurldrag.h>
#include <tdepopupmenu.h>
#include <kiconloader.h>
#include <tdelocale.h>

#include "urlnavigator.h"
#include "dolphin.h"


URLButton::URLButton(URLNavigator* parent)
: TQPushButton(parent),
  m_displayHint(0),
  m_urlNavigator(parent)
{
    setFocusPolicy(TQWidget::NoFocus);
    setSizePolicy(TQSizePolicy::Maximum, TQSizePolicy::Fixed);
    setMinimumHeight(parent->minimumHeight());

    connect(this, TQ_SIGNAL(clicked()), parent, TQ_SLOT(slotRequestActivation()));
    connect(&Dolphin::mainWin(), TQ_SIGNAL(activeViewChanged()),
            this, TQ_SLOT(update()));
}

URLButton::~URLButton()
{
}

URLNavigator* URLButton::urlNavigator() const
{
    return m_urlNavigator;
}

void URLButton::setDisplayHintEnabled(DisplayHint hint,
                                      bool enable)
{
    if (enable) {
        m_displayHint = m_displayHint | hint;
    }
    else {
        m_displayHint = m_displayHint & ~hint;
    }
    update();
}

bool URLButton::isDisplayHintEnabled(DisplayHint hint) const
{
    return (m_displayHint & hint) > 0;
}

void URLButton::enterEvent(TQEvent* event)
{
    TQPushButton::enterEvent(event);
    setDisplayHintEnabled(EnteredHint, true);
    update();
}

void URLButton::leaveEvent(TQEvent* event)
{
    TQPushButton::leaveEvent(event);
    setDisplayHintEnabled(EnteredHint, false);
    update();
}

TQColor URLButton::mixColors(const TQColor& c1,
                            const TQColor& c2) const
{
    const int red   = (c1.red()   + c2.red())   / 2;
    const int green = (c1.green() + c2.green()) / 2;
    const int blue  = (c1.blue()  + c2.blue())  / 2;
    return TQColor(red, green, blue);
}

#include "urlbutton.moc"
