/* The TdeGtk Theming Engine for Gtk+.
 * Copyright (C) 2011 Canonical Ltd
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Authored by Andrea Cimitan <andrea.cimitan@canonical.com>
 *
 */

#ifndef TDEGTK_ENGINE_H
#define TDEGTK_ENGINE_H

#include <gtk/gtk.h>

#include "tdegtk-types.h"

G_BEGIN_DECLS

#define TDEGTK_TYPE_ENGINE            (tdegtk_engine_get_type ())
#define TDEGTK_ENGINE(object)         (G_TYPE_CHECK_INSTANCE_CAST ((object), TDEGTK_TYPE_ENGINE, TdeGtkEngine))
#define TDEGTK_ENGINE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), TDEGTK_TYPE_ENGINE, TdeGtkEngineClass))
#define TDEGTK_IS_ENGINE(object)      (G_TYPE_CHECK_INSTANCE_TYPE ((object), TDEGTK_TYPE_ENGINE))
#define TDEGTK_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TDEGTK_TYPE_ENGINE))
#define TDEGTK_ENGINE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), TDEGTK_TYPE_ENGINE, TdeGtkEngineClass))

typedef struct _TdeGtkEngine TdeGtkEngine;
typedef struct _TdeGtkEngineClass TdeGtkEngineClass;

struct _TdeGtkEngine
{
  GtkThemingEngine parent_instance;
  TdeGtkStyleFunctions style_functions[TDEGTK_NUM_STYLES];
  TdeGtkStyles style;
};

struct _TdeGtkEngineClass
{
  GtkThemingEngineClass parent_class;
  TdeGtkStyleFunctions style_functions[TDEGTK_NUM_STYLES];
};

G_GNUC_INTERNAL void  tdegtk_engine_register_types (GTypeModule *module);

G_GNUC_INTERNAL GType tdegtk_engine_get_type       (void);

G_END_DECLS

#endif /* TDEGTK_ENGINE_H */
