//
// C++ Implementation: kbtaskview
//
// Description: 
//
//
// Author: Magnus Kulke <mkulke@magnusmachine>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include <tdelocale.h>

#include <tqptrlist.h>
#include <tqevent.h>

#include "kbtaskview.h"
#include "kbfileinfo.h"
#include "kbtransferitem.h"

KbTaskView::KbTaskView(TQWidget *parent, const char *name)
 : TDEListView(parent, name)
{
	addColumn(i18n("Task"));
	addColumn(i18n("Progress"));
	addColumn(i18n("Speed"));
	addColumn(i18n("Percentage"));
	addColumn(i18n("Remaining"));
	
	setRootIsDecorated(true);
	setSelectionMode(TQListView::Extended);
	setDragEnabled(true);
	setAcceptDrops(true);
		
	//connect(this, TQ_SIGNAL(doubleClicked(TQListViewItem*, const TQPoint&, int)),
	//	this, TQ_SLOT(SLOT_DoubleClicked(TQListViewItem*, const TQPoint&, int)));
}

KbTaskView::~KbTaskView()
{
}

TQListViewItem* KbTaskView::LastChild()
{
	TQListViewItem* last = NULL;
	TQListViewItem* it = lastItem();
	while (it)
	{
		last = it;
		it = it->parent();
	}
	return last;
}

void KbTaskView::SLOT_DoubleClicked(TQListViewItem* item, const TQPoint&, int)
{
	KbTransferItem *kti = static_cast<KbTransferItem*>(item);
	tqWarning("src: %s|%s", kti->SrcFileInfo()->filePath().latin1(), kti->SrcFileInfo()->fileName().latin1());
	tqWarning("dst: %s|%s", kti->DstFileInfo()->filePath().latin1(), kti->DstFileInfo()->fileName().latin1());
}

#include "kbtaskview.moc"
