
# Trinity-specific paths
import sys, os
tqt_modules = []
for m_path in sys.path:
    if os.path.exists(os.path.join(m_path, 'sip4_tqt')):
        m_sip_dir = os.path.join(m_path, 'sip4_tqt')
        tqt_modules.insert(0, m_sip_dir)
    if os.path.exists(os.path.join(m_path, 'PyTQt')):
        m_pytqt_dir = os.path.join(m_path, 'PyTQt')
        tqt_modules.insert(0, m_pytqt_dir)
for m_path in tqt_modules:
    sys.path.insert(0, m_path)

# Checking if the module is available
def is_module_available(module_name):
    if sys.version_info < (3, 0):
        # python 2
        import pkgutil
        mod_loader = pkgutil.find_loader(module_name)
    if sys.version_info <= (3, 3):
        # python 3.0 to 3.3
        import pkgutil
        mod_loader = pkgutil.find_loader(module_name)
    elif sys.version_info >= (3, 4):
        # python 3.4 and above
        import importlib.util
        mod_loader = importlib.util.find_spec(module_name)

    return mod_loader is not None

# Base modules
__all__ = [
 'tqt',
 'tqtcanvas',
 'tqtnetwork',
 'tqttable',
 'tqtsql',
 'tqtui',
 'tqtxml',
]

# Optional modules
if is_module_available('tqtaxcontainer'):
    __all__.append('tqtaxcontainer')
if is_module_available('tqtext'):
    __all__.append('tqtext')
if is_module_available('tqtgl'):
    __all__.append('tqtgl')

# Import namespaces
from PyTQt import *
