/*
 *
 *  Authorization Agent implementation of bluez5
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of tdebluezauth.
 *
 *  tdebluezauth is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  tdebluezauth is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef TDEAUTHAPP_H_
#define TDEAUTHAPP_H_

#include <kuniqueapplication.h>

#include <objectmanagerImpl.h>
#include "authservice.h"

class TDEBluezAuth: public KUniqueApplication
{
    TQ_OBJECT

public:
    TDEBluezAuth();
    virtual ~TDEBluezAuth();

    /*!
     * This function return information about connection status to the DBUS daemon.
     * \return boolean with the state of the connection to D-Bus
     * \retval true if connected
     * \retval false if disconnected
     */
    bool isConnectedToDBUS();

private:
    /*!
     * This function initialise the connection to the D-Bus daemon.
     * \return boolean with the result of the operation
     * \retval true if successful initialised D-Bus connection
     * \retval false if unsuccessful
     */
    bool configureAgent();
    //! to close the connection to D-Bus
    bool unconfigureAgent();

private:
    TQT_DBusConnection m_connection;

    AgentManager1Proxy* agentManager;
    RootNodeService *rootService;
    OrgNodeService   *orgService;
    TrinityDekstopNodeService *tdeNodeService;
    AuthService *authService;

public:
    TDEBluetooth::ObjectManagerImpl *manager;

public slots:
    //	void slotAdapterAdded(const TQString& adapter);
    //	void slotAdapterRemoved(const TQString& adapter);
    void slotPowerOnChanged(const TQString&, bool);

};

#endif // TDEAUTHAPP_H_
