/***************************************************************************
 *   Copyright (C) 2004-2005 by Luke Plant                                      *
 *   L.Plant.98@cantab.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KIOSWORD_H
#define KIOSWORD_H

#include "utils.h"
#include "swordoptions.h"
#include "renderer.h"

#include <kurl.h>
#include <tdeconfig.h>
#include <tdeio/slavebase.h>

#include <tqstring.h>
#include <tqcstring.h>

namespace KioSword {
	class Template;

	class SwordProtocol : public TDEIO::SlaveBase {
		
	public:
		SwordProtocol(const TQCString & pool_socket,
				const TQCString & app_socket);
		virtual ~SwordProtocol();
		virtual void mimetype(const KURL & url);
		virtual void get(const KURL & url);
	
	protected:
		void data(const TQCString& text);
		void data(const TQByteArray& text);
		
		void parseURL(const KURL & url);
		void readUserConfig();
		TQString saveUserConfig();
		
		void sendPage(const Template* tmplt);
		
		TQString helpPage();
		TQString pageLinks(const SwordOptions& options);
		TQString searchForm(const SwordOptions& options);
		TQString settingsForm();
		
		typedef enum { 	QUERY, 
				REDIRECT_QUERY, 
				SEARCH_FORM, 
				SEARCH_QUERY, 
				SETTINGS_FORM, 
				SETTINGS_SAVE, 
				HELP } ActionType;
	
		Renderer	m_renderer;
		SwordOptions 	m_options;
		ActionType 	m_action;
		DefModuleType 	m_moduletype;
		TQString 	m_path;
		Renderer::SearchType 	m_stype;
		KURL		m_baseurl;
			
		struct {
			TQString query;
			TQString module;
		} m_previous;
		
		struct {
			TQString query;
			TQString module;
		} m_redirect;
		
		TDEConfig *m_config;
		
	};
}

#endif
