/*
    tooltipeditdialog.cpp  -  Kopete Tooltip Editor

    Copyright (c) 2004 by Stefan Gehn <metz AT gehn.net>
    Kopete    (c) 2004 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "tooltipeditdialog.h"
#include "tooltipeditwidget.h"

#include "kopetecontactproperty.h"
#include "kopeteglobal.h"
#include "kopeteprefs.h"

#include <tqapplication.h>
#include <tqtoolbutton.h>
#include <tqheader.h>
#include <tqstringlist.h>

#include <kiconloader.h>
#include <tdelistview.h>
#include <tdelocale.h>

class TooltipItem : public TDEListViewItem
{
	public:
		TooltipItem(TDEListView *parent, const TQString& label, const TQString& propertyName)
			: TDEListViewItem(parent, label),
				mPropName(propertyName)
		{
		}

		TooltipItem(TDEListView *parent, TQListViewItem *item, const TQString& label, const TQString& propertyName)
			: TDEListViewItem(parent, item, label),
				mPropName(propertyName)
		{
		}

		TQString propertyName() const { return mPropName; }
	private:
		TQString mPropName;
};



TooltipEditDialog::TooltipEditDialog(TQWidget *parent, const char* name)
	: KDialogBase(parent, name, true, i18n("Tooltip Editor"), Ok|Cancel, Ok, true)
{
	mMainWidget = new TooltipEditWidget(this, "TooltipEditDialog::mMainWidget");
	setMainWidget(mMainWidget);
	mMainWidget->lstUsedItems->header()->hide();
	mMainWidget->lstUnusedItems->header()->hide();
	mMainWidget->lstUsedItems->setSorting( -1 );
	mMainWidget->lstUnusedItems->setSorting( 0 );

	const Kopete::ContactPropertyTmpl::Map propmap(
		Kopete::Global::Properties::self()->templateMap());
	TQStringList usedKeys = KopetePrefs::prefs()->toolTipContents();

    connect(mMainWidget->lstUnusedItems, TQ_SIGNAL(doubleClicked ( TQListViewItem *, const TQPoint &, int )), this, TQ_SLOT(slotAddButton()));
    connect(mMainWidget->lstUsedItems, TQ_SIGNAL(doubleClicked ( TQListViewItem *, const TQPoint &, int )), this, TQ_SLOT(slotRemoveButton()));

	// first fill the "used" list
	TQStringList::Iterator usedIt=usedKeys.end();
	do
	{
		usedIt--;
		// only add if that property key is really known
		if(propmap.contains(*usedIt) && !propmap[*usedIt].isPrivate())
		{
			new TooltipItem(mMainWidget->lstUsedItems,
				propmap[*usedIt].label(), *usedIt);
		}
	} while(usedIt != usedKeys.begin());

	// then iterate over all known properties and insert the remaining ones
	// into the "unused" list
	Kopete::ContactPropertyTmpl::Map::ConstIterator it;
	for(it = propmap.begin(); it != propmap.end(); ++it)
	{
		if((usedKeys.contains(it.key())==0) && (!it.data().isPrivate()))
			new TooltipItem(mMainWidget->lstUnusedItems, it.data().label(), it.key());
	}

	connect(mMainWidget->lstUnusedItems, TQ_SIGNAL(selectionChanged(TQListViewItem *)),
		this, TQ_SLOT(slotUnusedSelected(TQListViewItem *)));
	connect(mMainWidget->lstUsedItems, TQ_SIGNAL(selectionChanged(TQListViewItem *)),
		this, TQ_SLOT(slotUsedSelected(TQListViewItem *)));

	TQIconSet iconSet;
	iconSet = SmallIconSet("go-up");
	mMainWidget->tbUp->setIconSet(iconSet);
	mMainWidget->tbUp->setEnabled(false);
	mMainWidget->tbUp->setAutoRepeat(true);
	connect(mMainWidget->tbUp, TQ_SIGNAL(clicked()), TQ_SLOT(slotUpButton()));

	iconSet = SmallIconSet("go-down");
	mMainWidget->tbDown->setIconSet(iconSet);
	mMainWidget->tbDown->setEnabled(false);
	mMainWidget->tbDown->setAutoRepeat(true);
	connect(mMainWidget->tbDown, TQ_SIGNAL(clicked()), TQ_SLOT(slotDownButton()));

	iconSet = TQApplication::reverseLayout() ? SmallIconSet("back") : SmallIconSet("forward");
	mMainWidget->tbAdd->setIconSet(iconSet);
	mMainWidget->tbAdd->setEnabled(false);
	connect(mMainWidget->tbAdd, TQ_SIGNAL(clicked()), TQ_SLOT(slotAddButton()));

	iconSet = TQApplication::reverseLayout() ? SmallIconSet("forward") : SmallIconSet("back");
	mMainWidget->tbRemove->setIconSet(iconSet);
	mMainWidget->tbRemove->setEnabled(false);
	connect(mMainWidget->tbRemove, TQ_SIGNAL(clicked()), TQ_SLOT(slotRemoveButton()));

	connect(this, TQ_SIGNAL(okClicked()), this, TQ_SLOT(slotOkClicked()));

	resize(TQSize(450, 450));
}

void TooltipEditDialog::slotOkClicked()
{
	TQStringList oldList = KopetePrefs::prefs()->toolTipContents();
	TQStringList newList;
	TQListViewItemIterator it(mMainWidget->lstUsedItems);
	TQString keyname;

	while(it.current())
	{
		keyname = static_cast<TooltipItem *>(it.current())->propertyName();
		newList += keyname;
		kdDebug(14000) << k_funcinfo <<
			"Adding key '" << keyname << "' to tooltip list" << endl;
		++it;
	}

	if(oldList != newList)
	{
		KopetePrefs::prefs()->setToolTipContents(newList);
		emit changed(true);
		kdDebug(14000) << k_funcinfo << "tooltip fields changed, emitting changed()" << endl;
	}
}


void TooltipEditDialog::slotUnusedSelected(TQListViewItem *item)
{
	//mMainWidget->tbRemove->setEnabled(false);
	mMainWidget->tbAdd->setEnabled(item!=0);
}

void TooltipEditDialog::slotUsedSelected(TQListViewItem *item)
{
	mMainWidget->tbRemove->setEnabled(item!=0);
	//mMainWidget->tbAdd->setEnabled(false);
	if (item)
	{
		mMainWidget->tbUp->setEnabled(item->itemAbove() != 0);
		mMainWidget->tbDown->setEnabled(item->itemBelow() != 0);
	}
	else
	{
		mMainWidget->tbUp->setEnabled(false);
		mMainWidget->tbDown->setEnabled(false);
	}
}

void TooltipEditDialog::slotUpButton()
{
	TQListViewItem *item = mMainWidget->lstUsedItems->currentItem();
	TQListViewItem *prev = item->itemAbove();
	if(prev == 0) // we are first item already
		return;

	prev->moveItem(item);
	slotUsedSelected(item);
}

void TooltipEditDialog::slotDownButton()
{
	TQListViewItem *item = mMainWidget->lstUsedItems->currentItem();
	TQListViewItem *next = item->itemBelow();
	if(next == 0) // we are last item already
		return;

	item->moveItem(next);
	slotUsedSelected(item);
}

void TooltipEditDialog::slotAddButton()
{
	TooltipItem *item = static_cast<TooltipItem *>(mMainWidget->lstUnusedItems->currentItem());
	if(!item)
		return;
	//kdDebug(14000) << k_funcinfo << endl;

	// build a new one in the "used" list
	new TooltipItem(mMainWidget->lstUsedItems, item->text(0), item->propertyName());

	// remove the old one from "unused" list
	mMainWidget->lstUnusedItems->takeItem(item);
	delete item;
}

void TooltipEditDialog::slotRemoveButton()
{
	TooltipItem *item = static_cast<TooltipItem *>(mMainWidget->lstUsedItems->currentItem());
	if(!item)
		return;
	//kdDebug(14000) << k_funcinfo << endl;

	// build a new one in the "unused" list
	new TooltipItem(mMainWidget->lstUnusedItems, item->text(0), item->propertyName());

	// remove the old one from "used" list
	mMainWidget->lstUsedItems->takeItem(item);
	delete item;
}

#include "tooltipeditdialog.moc"
