/*
    translatorlanguages.h

    Kopete Translatorfish Translator plugin

    Copyright (c) 2001-2002 by Duncan Mac-Vicar Prett       <duncan@kde.org>
    Copyright (c) 2002-2003 by Olivier Goffart      <ogoffart @ kde.org>
    Copyright (c) 2003 by Matt Rogers                <matt@matt.rogers.name>

    Kopete    (c) 2002-2003 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef TRANSLATORLANGUAGES_H_
#define TRANSLATORLANGUAGES_H_

#include <tqmap.h>
#include <tqstringlist.h>

class TQString;


class TranslatorLanguages
{
public:
	TranslatorLanguages();

	/***************************************************************************
	 *   Language APIs                                                         *
	 ***************************************************************************/

	const TQString& languageName( const TQString &key )
	{ return m_langs[key]; };

	const int languageIndex	( const TQString &key )
	{ return m_langKeyIntMap[key]; };

	const TQString& languageKey( const int index )
	{ return  m_langIntKeyMap[index]; };

	const TQMap<TQString,TQString>& languagesMap()
	{ return m_langs; };

	const TQMap<TQString,TQString>& servicesMap()
	{ return m_services; };

	const TQStringList& supported( const TQString &servicekey )
	{ return m_supported[servicekey]; };

	const int serviceIndex	( const TQString &key )
	{ return m_servicesKeyIntMap[key]; };

	const TQString& serviceKey( const int index )
	{ return  m_servicesIntKeyMap[index]; };

	int numLanguages()	{ return m_lc; };

	int numServices()	{ return m_sc; };

private:

	/* Known Languages key -> desc ie: en -> English */
	TQMap< TQString, TQString> m_langs;

	/* Known Services key -> desc ie: en -> English */
	TQMap< TQString, TQString> m_services;

	/* Supported translations per service, src_dst format ( ie: en_es )*/
	TQMap< TQString, TQStringList > m_supported;

	/* int to lang key and viceversa*/
	TQMap<int, TQString> m_langIntKeyMap;
	TQMap<TQString, int> m_langKeyIntMap;

	/* int to services key and viceversa*/
	TQMap<int, TQString> m_servicesIntKeyMap;
	TQMap<TQString, int> m_servicesKeyIntMap;

	/* Lang counter */
	int m_lc;
	/* Service counter */
	int m_sc;

};

#endif
