
// (c) Pierpaolo Di Panfilo 2004
// See COPYING file for licensing information

#ifndef COVERMANAGER_H
#define COVERMANAGER_H

#include <tqptrlist.h>
#include <tqsplitter.h>
#include <kiconview.h>
#include <tqdialog.h>
#include <tqpixmap.h>

class TQListViewItem;
class CoverViewItem;
class ClickLineEdit;
class KPushButton;
class TDEPopupMenu;
class TQToolButton;
class TQLabel;
class TDEListView;
class CoverView;
class TQHBox;
class KProgress;
class TQHBoxLayout;
class PixmapViewer;

class CoverManager : public TQSplitter
{
        TQ_OBJECT
  

        static CoverManager *s_instance;

    public:
        CoverManager();
       ~CoverManager();

        static CoverManager *instance() { return s_instance; }

        static void showOnce( const TQString &artist = TQString() );
        static void viewCover( const TQString& artist, const TQString& album, TQWidget *parent=0 );

        void setStatusText( TQString text );

         /**
         * Return the top level domain for the current locale
         **/
        static TQString amazonTld();
    public slots:
        void updateStatusBar();
        void changeLocale( int id );

    private slots:
        void slotArtistSelected( TQListViewItem* );
        void coverItemExecuted( TQIconViewItem *item );
        void showCoverMenu( TQIconViewItem *item, const TQPoint& );
        void slotSetFilter();
        void slotSetFilterTimeout();
        void changeView( int id );
        void fetchMissingCovers();
        void fetchCoversLoop();
        void coverFetched( const TQString&, const TQString& );
        void coverRemoved( const TQString&, const TQString& );
        void coverFetcherError();
        void stopFetching();

        void init();

    private:
        enum View { AllAlbums=0, AlbumsWithCover, AlbumsWithoutCover };

        void loadCover( const TQString &, const TQString & );
        void setCustomSelectedCovers();
        void fetchSelectedCovers();
        void deleteSelectedCovers();
        TQPtrList<CoverViewItem> selectedItems();

        TDEListView      *m_artistView;
        CoverView      *m_coverView;
        ClickLineEdit  *m_searchEdit;
        KPushButton    *m_fetchButton;
        TDEPopupMenu     *m_amazonLocaleMenu;
        TDEPopupMenu     *m_viewMenu;
        TQToolButton    *m_amazonLocaleButton;
        TQToolButton    *m_viewButton;
        int             m_currentLocale;
        int             m_currentView;

        //status bar widgets
        TQLabel         *m_statusLabel;
        TQHBox          *m_progressBox;
        KProgress      *m_progress;
        TQString         m_oldStatusText;

        TQTimer         *m_timer;              //search filter timer
        TQPtrList<TQIconViewItem> m_coverItems; //used for filtering
        TQString         m_filter;


        // Used by fetchCoversLoop() for temporary storage
        TQStringList m_fetchCovers;
        uint m_fetchCounter;

        //used to display information about cover fetching in the status bar
        int m_fetchingCovers;
        int m_coversFetched;
        int m_coverErrors;
};

class CoverView : public TDEIconView
{
        TQ_OBJECT
  

    public:
        CoverView( TQWidget *parent = 0, const char *name = 0, WFlags f = 0 );

    protected:
        TQDragObject *dragObject();

    private slots:
        void setStatusText( TQIconViewItem *item );
};

class CoverViewItem : public TDEIconViewItem
{
    public:
        CoverViewItem( TQIconView *parent, TQIconViewItem *after, const TQString &artist, const TQString &album );

        void loadCover();
        bool hasCover() const;
        bool canRemoveCover() const { return !m_embedded && hasCover(); }
        TQString artist() const { return m_artist; }
        TQString album() const { return m_album; }
        TQPixmap coverPixmap() const { return m_coverPixmap; }

    protected:
        void paintItem(TQPainter* painter, const TQColorGroup& colorGroup);
        void paintFocus(TQPainter *, const TQColorGroup &) { }
        void dropped( TQDropEvent *, const TQValueList<TQIconDragItem> & );
        void dragEntered();
        void dragLeft();
        void calcRect( const TQString& text_=TQString() );

    private:
        TQString m_artist;
        TQString m_album;
        TQString m_coverImagePath;
        TQPixmap m_coverPixmap;
        bool    m_embedded;
};


class CoverViewDialog : public TQDialog {
        TQ_OBJECT
  

    public:
        CoverViewDialog(const TQString& artist, const TQString& album, TQWidget *parent);

    private:
        TQHBoxLayout *m_layout;
        TQPixmap m_pixmap;
        PixmapViewer *m_pixmapViewer;
        TQLabel *m_label;
};

#endif
