/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** TQt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#include "directorylist.h"

#include <kdialogbase.h>
#include <tdeconfig.h>
#include <tdeglobal.h>

void KlamOnAccConfig::reconfigurePaths() {
    // Borrowed from amaroK (collectionbrowser.cpp)
    KDialogBase dialog( this, 0, false );
    // tdeApp->setTopWidget( &dialog );
    dialog.setCaption( "Configure Directories Watchlist" );
    
    TDEConfig *config = TDEGlobal::config();
    config->setGroup("OnAccess");
    TQStringList dirs = config->readListEntry("Watchlist");

    CollectionSetup *setup = new CollectionSetup( &dialog, true, false, dirs );
    dialog.setMainWidget( setup );
    dialog.showButtonApply( false );
    dialog.adjustSize();

    // Make the dialog a bit bigger, default is too small to be useful
    dialog.resize( dialog.width() + 50, dialog.height() + 150 );

    if ( dialog.exec() != TQDialog::Rejected ) {
        setup->writeConfig("OnAccess","Watchlist");
    }
    
    restart = true;
}

void KlamOnAccConfig::slotSettingsChanged() {
    restart = true;
}

void KlamOnAccConfig::slotSettingsApplied() {
    restart = false;
}

bool KlamOnAccConfig::needsRestart() {
    return restart;
}
