/*
 *  Copyright (c) 2000 Matthias Elter  <elter@kde.org>
 *  Copyright (c) 2003 Patrick Julien  <freak@codepimps.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.g
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <tqpainter.h>
#include <koIconChooser.h>
#include "kis_iconwidget.h"

KisIconWidget::KisIconWidget(TQWidget *parent, const char *name) : super(parent, name)
{
    m_item = 0;
}

void KisIconWidget::slotSetItem(KoIconItem& item)
{
    m_item = &item;
    update();
}

void KisIconWidget::drawButtonLabel(TQPainter *p)
{
    if (m_item) {
        const TQPixmap& pix = m_item->pixmap();
        TQ_INT32 x = 2;
        TQ_INT32 y = 2;
        TQ_INT32 pw = pix.width();
        TQ_INT32 ph = pix.height();
        TQ_INT32 cw = width();
        TQ_INT32 ch = height();
        TQ_INT32 itemWidth = 24;
        TQ_INT32 itemHeight = 24;

        if (pw < itemWidth)
            x = (cw - pw) / 2;
        if (ph < itemHeight)
            y = (cw - ph) / 2;

        if (!m_item->hasValidThumb() || (pw <= itemWidth && ph <= itemHeight)) {
            p->drawPixmap(x, y, pix, 0, 0, itemWidth, itemHeight);
        } else {
            const TQPixmap& thumbpix = m_item->thumbPixmap();

            x = 2;
            y = 2;
            pw = thumbpix.width();
            ph = thumbpix.height();
            cw = width();
            ch = height();

            if (pw < itemWidth)
                x = (cw - pw) / 2;

            if (ph < itemHeight)
                y = (cw - ph) / 2;

            p->drawPixmap(x, y, thumbpix, 0, 0, itemWidth, itemHeight);
        }

        p->setPen(gray);
        p->drawRect(0, 0, cw + 1, ch + 1);
    }
}

#include "kis_iconwidget.moc"

